#include "stdafx.h"






// no more padding 0 at end of row since we calloc
void doScaleImageInBytes(PBYTE DstBuffer, DWORD DstSize, DWORD WidthInPixel, DWORD WidthInBytes, DWORD PageHeight, DWORD HardXDpi, 
		DWORD HardYDpi, DWORD SoftXDpi, DWORD SoftYDpi, PBYTE scaledBuffer, DWORD scaledBufferSize, 
		DWORD scaledWidthInPixel, DWORD	scaledHeightInPixel, DWORD scaledWidthInBytes, DWORD BitCount)
{
	DWORD BytesPerPixel = BitCount / 8;
	int rowCarryon = 0, colCarryon = 0, rowDiff = SoftYDpi - PageHeight, colDiff = SoftXDpi - HardXDpi;
	PBYTE srcRowPtr = NULL, dstRowPtr = NULL;
	PBYTE srcColPtr = NULL, dstColPtr = NULL;


	WidthInBytes = WidthInPixel * BitCount / 8;

	srcRowPtr = DstBuffer;
	dstRowPtr = scaledBuffer;

	
	/*
	int paddedBytes = 0;

	paddedBytes = scaledWidthInBytes - BitCount / 8 * scaledWidthInPixel;
	// init
	*/

	rowCarryon = 0;
	for (int dstRow = 0; dstRow < scaledHeightInPixel; dstRow ++)
	{				

		dstColPtr = dstRowPtr;
		srcColPtr = srcRowPtr;

		// definitely we need to init
		colCarryon = 0;

		for (int dstCol = 0; dstCol < scaledWidthInPixel; dstCol ++)
		{
			
			memcpy(dstColPtr, srcColPtr, BytesPerPixel);
			//dst col ptr always advance
			dstColPtr += BytesPerPixel;

			//here we calculate col carryon to decide if src col ptr needs advancing.
			
			if (colCarryon >= HardXDpi){
				colCarryon -= HardXDpi;
			}else{
				srcColPtr += BytesPerPixel;
				colCarryon += colDiff;
			}

		}		
		
		//dst row always move on
		dstRowPtr += scaledWidthInBytes;

		/*
		// padding 0 at end of row;
		dstColPtr += BytesPerPixel;//first, advance
		
		memset(dstColPtr, 0, paddedBytes);
		*/
		//here we calculate carryon to decide if src row need to advance
		

		if (rowCarryon >= HardYDpi){
			//in this case, we copy current row by not advancing
			rowCarryon -= HardYDpi; 
		}else{
			//we advance src row to next
			srcRowPtr += WidthInBytes;
			rowCarryon += rowDiff;
		}
	}

}


// QH: handling bits copying is painful, so I decide to only support of 1bpp, or BitCount=1
// actually, the padding 0 is really not necessary if we use "calloc" to initialize memory
void doScaleImageInBits(PBYTE DstBuffer, DWORD DstSize, DWORD WidthInPixel, DWORD WidthInBytes, DWORD PageHeight, DWORD HardXDpi, 
		DWORD HardYDpi, DWORD SoftXDpi, DWORD SoftYDpi, PBYTE scaledBuffer, DWORD scaledBufferSize, 
		DWORD scaledWidthInPixel, DWORD	scaledHeightInPixel, DWORD scaledWidthInBytes, DWORD BitCount)
{
	int rowCarryon = 0, colCarryon = 0, rowDiff = SoftYDpi - PageHeight, colDiff = SoftXDpi - HardXDpi;
	PBYTE srcRowPtr = NULL, dstRowPtr = NULL;
	PBYTE srcColPtr = NULL, dstColPtr = NULL;
	BYTE  srcMask, dstMask;


	WidthInBytes = WidthInPixel * BitCount / 8;

	srcRowPtr = DstBuffer;
	dstRowPtr = scaledBuffer;

	/*
	int paddedBytes = 0;

	paddedBytes = scaledWidthInBytes - (scaledWidthInPixel + 7) / 8;
	// init
	*/
	for (int dstRow = 0; dstRow < scaledHeightInPixel; dstRow ++)
	{		
		dstColPtr = dstRowPtr;
		srcColPtr = srcRowPtr;

		colCarryon = 0; //don't forget!!!

		srcMask = 0x80;
		srcMask = 0x80;

		for (int dstCol = 0; dstCol < scaledWidthInPixel; dstCol ++)
		{	
			// get src bit and then copy dst bit
			if (srcMask & (*srcColPtr)){
				*dstColPtr |= dstMask;
			} 
			// we don't write 0 because we use "calloc" to initialize to 0
			/*
			else { 
				*dstColPtr &= (~dstMask);//set to 0
			}
			*/
			
			//dst col ptr always advance
			dstMask = dstMask >> 1;
			if (! dstMask){
				// this means we cross byte
				dstColPtr ++; //1bpp
				dstMask = 0x80;
			}

			//here we calculate col carryon to decide if src col ptr needs advancing.
			
			if (colCarryon >= HardXDpi){
				// here we don't advance, we repeat source by not advancing srcColptr
				colCarryon -= HardXDpi;
			}else{
				//here we move srcColptr
				colCarryon += colDiff;
				srcMask = srcMask >> 1;
				if (! srcMask){
					srcColPtr ++;
					srcMask = 0x80;
				}
			}
		}
		//dst row always move on
		dstRowPtr += scaledWidthInBytes;
		// here we need pad 0 till end of row
		//first, we need position our pointer correctly
		/*
		if (dstMask){
			dstColPtr ++;
		}
		while (dstMask)
		{
			*dstColPtr &= (~dstMask);//set to 0
			dstMask = dstMask >> 1;
		}

		memset(dstColPtr, 0, paddedBytes);
		*/

		//here we calculate carryon to decide if src row need to advance
		

		if (rowCarryon >= HardYDpi){
			//in this case, we copy current row by not advancing
			rowCarryon -= HardYDpi; 
		}else{
			//we advance src row to next
			rowCarryon += rowDiff;
			srcRowPtr += WidthInBytes;
		}
	}
}



BOOL scaleImage(PBYTE &DstBuffer, DWORD &DstSize, PBYTE srcBuffer, DWORD srcSize, DWORD BitCount, 
	LONG& WidthInPixel, LONG& WidthInBytes, 
	LONG& PageHeight, DWORD HardXDpi, DWORD HardYDpi, DWORD SoftXDpi, DWORD SoftYDpi)
{
	DWORD scaledWidthInPixel =0, scaledHeightInPixel = 0, scaledWidthInBytes = 0, scaledBufferSize = 0;

	PBYTE scaledBuffer = NULL;
	

	scaledWidthInPixel  = (WidthInPixel * SoftXDpi) / HardXDpi;
	scaledHeightInPixel = (PageHeight * SoftYDpi) / HardYDpi;
	scaledWidthInBytes  = ((scaledWidthInPixel * BitCount + 31) & (~31)) / 8;

	scaledBufferSize = scaledWidthInBytes * scaledHeightInPixel;

	if (scaledBufferSize >= srcSize){
		// we initialize to 0, then we don't have to pad 0
		if ((scaledBuffer = (PBYTE)calloc(scaledBufferSize, 1)) == NULL){
			return FALSE;
		}
	}

	switch (BitCount)
	{
	case 8:
	case 24:
		doScaleImageInBytes(srcBuffer, srcSize, WidthInPixel, WidthInBytes, PageHeight, HardXDpi, HardYDpi, 
			SoftXDpi, SoftYDpi, scaledBuffer, scaledBufferSize, scaledWidthInPixel, 
			scaledHeightInPixel, scaledWidthInBytes, BitCount);
		break;
	
	case 1:
		doScaleImageInBits(srcBuffer, srcSize, WidthInPixel, WidthInBytes, PageHeight, HardXDpi, HardYDpi, 
			SoftXDpi, SoftYDpi, scaledBuffer, scaledBufferSize, scaledWidthInPixel, 
			scaledHeightInPixel, scaledWidthInBytes, BitCount);
		break;
	}
	//swap buffer
	
	DstBuffer    = scaledBuffer;
	DstSize      = scaledBufferSize;
	WidthInPixel = scaledWidthInPixel;
	PageHeight   = scaledHeightInPixel;
	WidthInBytes = scaledWidthInBytes;

	return TRUE;
}




bool scalePicture(LPCTSTR fileName)
{

	RGBQUAD monoColor[2] =
	{
		{0, 0, 255, 0},
		{255, 0, 0, 0}
	};

	bool result = false;


	PBITMAPINFO pbi = NULL;
	PBITMAPINFOHEADER pbih;
	LPBYTE pbits;
	long widthBytes = 0;
	LPBYTE dstBuffer = NULL;
	DWORD  dstSize = 0, srcSize;

	LPBYTE ptr;
	int colorNumber = 0;
	long scaledWidth, scaledHeight;
	DWORD bitCount;
	

	if (readImageFile(fileName, pbi))
	{
		pbih = (PBITMAPINFOHEADER)(pbi);
	
		widthBytes = ((pbih->biWidth * pbih->biBitCount + 31)&(~31)) / 8;

		colorNumber = pbih->biClrUsed;
		if (pbih->biBitCount < 16 && pbih->biClrUsed == 0)
		{
			colorNumber = (1 << pbih->biBitCount);
		}




		pbits = ((LPBYTE)(pbi)+ colorNumber * sizeof(RGBQUAD) + sizeof(BITMAPINFOHEADER));
		scaledWidth = pbih->biWidth;
		scaledHeight = pbih->biHeight;
		srcSize = widthBytes * scaledHeight;
		scaleImage(dstBuffer, dstSize, pbits, srcSize, pbih->biBitCount, scaledWidth, widthBytes, scaledHeight, pbih->biWidth,
			pbih->biHeight, pbih->biWidth * 1, pbih->biHeight * 1);

		result = true;
	
		bitCount = pbih->biBitCount;
		free(pbi);
		if (result)
		{
			pbi = (PBITMAPINFO)malloc(sizeof(BITMAPINFOHEADER) + dstSize);
			pbih = (PBITMAPINFOHEADER)(pbi);
			memset(pbi, 0, sizeof(BITMAPINFOHEADER));
			pbih->biBitCount= bitCount;
			pbih->biSize = sizeof(BITMAPINFOHEADER);
			pbih->biWidth = scaledWidth;
			pbih->biHeight = scaledHeight;
			pbih->biPlanes =1;
			
			
	
			
    
			colorNumber = pbih->biClrUsed;
			// only support mono
			if (pbih->biBitCount == 1) 
			{
			   colorNumber = (1 << pbih->biBitCount);
			   memcpy(&pbi->bmiColors[0], monoColor, sizeof(RGBQUAD) * 2);
			}    
			
			pbits = (LPBYTE)pbi + pbih->biSize + colorNumber * sizeof(RGBQUAD);

			memcpy(pbits, dstBuffer, dstSize);
			createBmpFile(_T("result.bmp"), pbi);
		}


    }

   
   
   
   return result;
}



int _tmain(int argc, LPCTSTR* argv)
{
	/*
	if (argc == 2)
   {
      if (countColor(argv[1]))
      {
         printf("succeed\n");
      }
   }  
   */

	scalePicture(_T("input.bmp"));


   return 0;
}
