#define MYIJGLIB 1

#ifdef MYIJGLIB
#define MYAPI
#pragma comment(lib, "staticIJG.lib")
#else
#ifdef MYGRAPHICDLL
#define MYAPI __declspec(dllexport)
#else
#ifdef MYGRAPHICLIB
#define MYAPI
#else
#define MYAPI __declspec(dllimport)
#endif//lib
#endif//dll
#endif

#define JPEG_SUCCESS                      0
#define JPEG_FAILURE                     -1

#define JPEG_ERROR_IJL_INIT             100
#define JPEG_ERROR_IJL_READ_PARAM       101
#define JPEG_ERROR_IJL_WRITE            102
#define JPEG_ERROR_IJL_READ_DATA        104
#define JPEG_ERROR_IJL_FREE             105
#define JPEG_ERROR_INVALID_FORMAT       106
#define JPEG_ERROR_FILE_CREATE          107
#define JPEG_ERROR_FILE_WRITE           108
#define JPEG_ERROR_INVALID_PARAM        109
#define JPEG_ERROR_READ_BITS            110
#define JPEG_ERROR_CREATE_FILE          111
#define JPEG_ERROR_SET_STRETCH          112

#define JPEG_ERROR_UNSUPPORT_FORMAT     113


#define JPEG_ERROR_MEMORY_ALLOC         120


const int DefaultThumbnailSize = 64;
const int DefaultMaxHeight     = 500;


enum ImageFileFormat
{
	Image_File_Format_BMP, Image_File_Format_JPG, Image_File_Format_PNG,
	Image_File_Format_TIF, Image_File_Format_GIF, Image_File_Format_UNKNOWN
};



MYAPI int __stdcall readJpgFile(const char* src, PBITMAPINFO& pbi);
//int createBmpFile(const TCHAR* pszFile, PBITMAPINFO pbi, LPBYTE lpBits);
MYAPI int __stdcall createBmpFile(const TCHAR* pszFile, PBITMAPINFO pbi);
//int scaleBmp(PBITMAPINFO pbi,  LPBYTE& lpNewBits, int width, int height);
MYAPI int __stdcall readJpgBuffer(const LPBYTE src, DWORD size, PBITMAPINFO& pbi);
MYAPI int  __stdcall readBmpBuffer(PBITMAPINFO pbi, LPBYTE& dest, DWORD& size);

//int createBmpInfoStruct(const BITMAP& bmp, PBITMAPINFO& pbmi);
MYAPI int __stdcall  scaleBmp(PBITMAPINFO& pbi, int width, int height);

MYAPI int __stdcall  saveImageFile(const TCHAR* fileName, const LPBYTE dest, DWORD size);
MYAPI int __stdcall  scaleTo(const LPBYTE jpgPtr, DWORD jpgSize, int thumbWidth, int thumbHeight, 
		int& imageWidth, int& imageHeight, LPBYTE& pbits, DWORD& stretchedSize);

MYAPI int __stdcall  scaleLessThan(const LPBYTE jpgPtr, DWORD jpgSize, int maxHeight, LPBYTE& pbits,
		int& stretchedWidth, int& stretchedHeight, DWORD& stretchedSize);

#if 0
MYAPI int __stdcall  imageProcess(LPBYTE imagePtr, DWORD imageSize, int maxHeight, int thumbSize,
		int& imageWidth, int& imageHeight, int& stretchedWidth, int& stretchedHeight,
		LPBYTE& thumbPtr,
		LPBYTE& stretchedPtr, DWORD& thumbDataSize, DWORD& stretchedSize);
#endif
MYAPI ImageFileFormat __stdcall  imageFileFormat(const LPBYTE image);

MYAPI int  __stdcall scaleBmp(PBITMAPINFO pbi, LPBYTE pbits, LPBYTE& lpNewBits, int width, int height);
MYAPI void  __stdcall saveToFile(TCHAR* fileName);


MYAPI bool  __stdcall createWatermark(LPBYTE jpgSrc, DWORD jpgSrcSize, HBITMAP hBmpMark, LPBYTE& jpgDest, 
					 DWORD& jpgDestSize, unsigned long index = SRCCOPY);

MYAPI bool __stdcall  saveScreenToBmpFile(TCHAR* fileName);
MYAPI bool __stdcall  saveScreenToJpgFile(TCHAR* fileName);
MYAPI bool __stdcall  saveScreenToJpgBuffer(LPBYTE& dataBuffer, DWORD& dataSize);
MYAPI bool __stdcall  saveScreenToBmp(PBITMAPINFO& pbmi);

