#define XMD_H
#include <stdio.h>
#include "myIJGDll.h"
#include "jpeglib.h"
#include <windows.h>


//input buffer must be "BITMAPINFO"
MYIJGAPI jCompress(unsigned char *dest, unsigned long *destLen, const unsigned char *source, unsigned long sourceLen, int quality)
{
	jpeg_descriptor descriptor;


	PBITMAPINFOHEADER pbhi = NULL;
	int    colorNumber = 0;
	int    widthBytes  = 0;
	LPBYTE  pbits = NULL;

 
	if (dest == NULL || source == NULL || *destLen < sourceLen || sourceLen <= 40)
	{
		return false;
	}  

	pbhi = (PBITMAPINFOHEADER)source;

	//let's make life easier
	if (pbhi->biBitCount != 24)
	{
	    return false;
	}

	pbits = 	(LPBYTE)source + pbhi->biSize;

	descriptor.imageWidth   = pbhi->biWidth;
	descriptor.imageHeight  = pbhi->biHeight;


	widthBytes = (pbhi->biWidth * 3 + 3)&(~3);

	descriptor.inSize       = sourceLen - pbhi->biSize;

	if (descriptor.inSize != widthBytes * descriptor.imageHeight)
	{
		return false;
	}

	descriptor.padBytes     = widthBytes - (pbhi->biWidth * 3);      

	descriptor.inputBuffer  = pbits;

	descriptor.outputBuffer = dest;
	descriptor.outSize      = *destLen;
	descriptor.isBGR        = true;
	descriptor.isUpsidedown = true;
	descriptor.quality = quality;

	compressJPGm2m(&descriptor);
	*destLen = descriptor.outSize;

	return true;
}





MYIJGAPI jDecompress(unsigned char*dest, unsigned long *destLen, const unsigned char *source, unsigned long sourceLen)
{
	jpeg_descriptor descriptor;

	PBITMAPINFOHEADER pbhi = NULL;
	int    rowNumber = 0;
	int    widthBytes  = 0;
	LPBYTE  pbits = NULL;

	if (dest == NULL || source == NULL || *destLen <= 0 || sourceLen <= 0)
	{
	  return false;
	}

	pbhi = (PBITMAPINFOHEADER)dest;

	pbits = 	(LPBYTE)dest + sizeof(BITMAPINFOHEADER);

	descriptor.inputBuffer  = const_cast<unsigned char*>(source);
	descriptor.inSize       = sourceLen;
	descriptor.outputBuffer = pbits;
	descriptor.outSize      = *destLen - sizeof(BITMAPINFOHEADER);
	descriptor.isUpsidedown = true;
	descriptor.isBGR        = true;


	rowNumber = deCompressJPGm2m(&descriptor);
	if (rowNumber != descriptor.imageHeight)
	{
	  return false;
	}

	memset(pbhi, 0, sizeof(BITMAPINFOHEADER));
	pbhi->biSize = sizeof(BITMAPINFOHEADER);
	pbhi->biWidth = descriptor.imageWidth;
	pbhi->biHeight = descriptor.imageHeight;
	pbhi->biPlanes = 1;
	pbhi->biBitCount = 24;
	pbhi->biCompression = BI_RGB;

	return true;
}



MYIJGAPI jCompressFile(char *inputFileName, char* outputFileName, int quality)
{   
	/*
   bool result = false;
	long rowBytes = 0, offset = 0;
   BYTE* inputBuffer;
   BYTE* outputBuffer;
   DWORD inSize =0, outSize = 0;
   size_t res =0;
   unsigned char* ptr = NULL;
   BITMAPFILEHEADER bmpFileHeader;
   BITMAPINFOHEADER bmpInfoHeader;
   FILE* inputFile = NULL, *outputFile = NULL;
 
   if (inputFileName == NULL || outputFileName==NULL)
   {
      return false;
   }
   if ((inputFile = fopen(inputFileName, "r+b"))!= NULL)
   {
      if ((outputFile=fopen(outputFileName, "w+b"))!= NULL)
      {
         if (fread(&bmpFileHeader, sizeof(BITMAPFILEHEADER), 1, inputFile)== 1)
         {
            if (bmpFileHeader.bfType == 0x4d42)
            {
               if (fread(&bmpInfoHeader, sizeof(BITMAPINFOHEADER), 1, inputFile)== 1)
               {
                  if (bmpInfoHeader.biBitCount == 24)
                  {
                     offset = bmpFileHeader.bfOffBits - sizeof(BITMAPINFOHEADER);

                     rowBytes = (bmpInfoHeader.biWidth * 3 + 3)&(~3);                                          
                     
                     inSize = bmpInfoHeader.biHeight*rowBytes + sizeof(BITMAPINFOHEADER);
                     outSize = inSize;
                     fseek(inputFile, bmpFileHeader.bfOffBits, SEEK_SET);

                     if ((inputBuffer=(PBYTE) malloc(inSize)) != NULL)
                     {
                        if ((outputBuffer = (PBYTE)malloc(outSize))!= NULL)
                        {                           
                           memcpy(inputBuffer, &bmpInfoHeader, sizeof(BITMAPINFOHEADER));
                           
                           if (fread(inputBuffer + sizeof(BITMAPINFOHEADER), inSize - sizeof(BITMAPINFOHEADER), 1, inputFile) ==1)
                           {
                              if (jCompress(outputBuffer, &outSize, inputBuffer, inSize, quality))
                              {
                                 if (fwrite(outputBuffer, outSize, 1, outputFile)==1)
                                 {
                                    result = true;
                                 }
                              }
                           }
                           free(outputBuffer);
                        }
                        free(inputBuffer);
                     }
                  }
               }
            }
         }
         fclose(outputFile);
      }
      fclose(inputFile);
   }
   return result;
   */
   
   return compressJPG(inputFileName, outputFileName, quality) == 0;
}


MYIJGAPI jDecompressFile(char *inputFileName, char* outputFileName)
{ 
   /*
   bool result = false;
	int rowBytes = 0, offset = 0;
   LPBYTE inputBuffer;
   LPBYTE outputBuffer;
   DWORD inSize =0, outSize = 0;
   size_t res =0;
   unsigned char* ptr = NULL;
   BITMAPFILEHEADER bmpFileHeader;
   PBITMAPINFOHEADER pBmpInfoHeader;
   FILE* inputFile = NULL, *outputFile = NULL;

   if (inputFileName == NULL || outputFileName==NULL)
   {
      return false;
   }
   if (mapFileForRead(inputFileName, inputBuffer, inSize))
   {
      outSize = 40*inSize;
      if ((outputBuffer=(PBYTE) malloc(outSize)) != NULL)
      {
         if (jDecompress(outputBuffer, &outSize, inputBuffer, inSize))
         {
            pBmpInfoHeader = (PBITMAPINFOHEADER)outputBuffer;
            memset(&bmpFileHeader, 0, sizeof(BITMAPFILEHEADER));
            bmpFileHeader.bfType = 0x4d42;
            bmpFileHeader.bfSize = sizeof(BITMAPFILEHEADER) + outSize;
            bmpFileHeader.bfOffBits = sizeof(BITMAPFILEHEADER) + sizeof(PBITMAPINFOHEADER);

            if ((outputFile=fopen(outputFileName, "w+b"))!= NULL)
            {
               if (fwrite(&bmpFileHeader, sizeof(BITMAPFILEHEADER), 1, outputFile)==1)
               {
                  if (fwrite(outputBuffer, outSize, 1, outputFile)==1)
                  {
                     result = true;
                  }
               }
            }
         }
         free(outputBuffer);
      }
      unmapFile(inputBuffer);      
   }   
   return result; 
   */
   
   return deCompressJPG(inputFileName, outputFileName, FMT_BMP)==0;
}



