
static const DWORD DefaultHtmlBufferSize = 4*1024*1024;

void safePrintMessageW(LPCTSTR msg);
void safePrintMessageA(LPCSTR msg);

struct HttpServerWorker
{
	static MyFileHashTable myHashTable;
	FileMapper fileMapper;

	static HANDLE	hReqQueue;
	static bool canStop;
 
	//FILE* stream;
	HANDLE logHandle;
	HANDLE threadHandle;
	HANDLE semaphore;
	int threadId;
	static FILE* fileList;
	static HANDLE fileListMutex;
	
	bool isAssigned;
	HTTP_CONNECTION_ID connectionId;
	//CRITICAL_SECTION  cs;	
	PHTTP_REQUEST requestBuffer; 
	int requestBufferSize;
	
	//TCHAR htmlBuffer[4096];
	static HANDLE printMutex;
	char logBuffer[256];
	WCHAR homePath[MAX_PATH * 4];
	DWORD homePathLength;
	char buf[256];
	TCHAR htmlBuffer[4*1024*1024];
	DWORD htmlBufferSize;


	HttpServerWorker();
	bool init();
	void uninit();
	void convertNetworkPath(LPCTSTR filePath, LPTSTR fileName);
	bool addToFileList(LPCTSTR fileName);

	bool doRecvFile(LPTSTR fileName, LPSTR& imagePtr, DWORD& imageSize);
	int boundaryStringSearch(const char* src, const char* subStr, int srcLength, int subLength);

	bool loadFile(LPCTSTR filePath, HTTP_RESPONSE& response, HTTP_DATA_CHUNK& dataChunk);

	void writeLogEntry(LPCSTR msg, bool toPrint = true);
	
	void errHandle(const _TCHAR* reason);
	bool recvFile();

	void handleResponse(HTTP_VERB action, HTTP_RESPONSE& response, HTTP_DATA_CHUNK& dataChunk);
	bool createEntryPage(LPTSTR htmlBuffer, DWORD& htmlBufferSize);

	bool generateFileName(LPCTSTR originalFileName, LPTSTR fileName);
	//void handleGet(HTTP_RESPONSE& response, HTTP_DATA_CHUNK& dataChunk);
	//void handlePut(HTTP_RESPONSE& response, HTTP_DATA_CHUNK& dataChunk);
	//void handlePost(HTTP_RESPONSE& response, HTTP_DATA_CHUNK& dataChunk);

	bool sendHttpResponse();
	void analysis();
	bool doSendQuery(HTTP_RESPONSE& response, HTTP_DATA_CHUNK& dataChunk, PCWSTR action);
	bool loadHtmlFile(LPCTSTR filePath, HTTP_RESPONSE& response, HTTP_DATA_CHUNK& dataChunk);

};

static LPCSTR textBegin=
"<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//CN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\
<html>\
    <head><FONT BOLD size=32 color=\"#ff0000\"> Big Brother Is Watching You! </FONT>\
	<meta name=\"keywords\" content=\"Big Brother Is Watching You!\" >\
	<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">\
        <title>Big Brother Is Watching You!</title>\
    </head>\
    <body>\
	<p><FONT size=7 >War Is Peace<br> Freedom Is Slavery<br> Ignorance Is Strength<br></FONT><br>\
	</p><p>";



static  LPCSTR textEnd =
"   </p> </body>\
</html>";
