#include "stdafx.h"




HANDLE HttpServerWorker::printMutex = NULL;

HANDLE HttpServerWorker::hReqQueue = NULL;
bool HttpServerWorker::canStop = false;

FILE* HttpServerWorker::fileList = NULL;
HANDLE HttpServerWorker::fileListMutex = NULL;



void safePrintMessageW(LPCTSTR msg)
{
	if (HttpServerWorker::printMutex != NULL && 
		WaitForSingleObject(HttpServerWorker::printMutex, 5000) == WAIT_OBJECT_0)
	{
		_tprintf(_T("%s\n"), msg);
		ReleaseMutex(HttpServerWorker::printMutex);
	}
	else
	{
		_tprintf(_T("%s\n"), msg);
	}
}
	
void safePrintMessageA(LPCSTR msg)
{
	if (HttpServerWorker::printMutex != NULL &&
		 WaitForSingleObject(HttpServerWorker::printMutex, 5000) == WAIT_OBJECT_0)
	{
		printf("%s", msg);
		ReleaseMutex(HttpServerWorker::printMutex);
	}
	else
	{
		printf("%s", msg);
	}
}	 
		
HttpServerWorker::HttpServerWorker()
{
	init();
}



void HttpServerWorker::writeLogEntry(LPCSTR msg, bool toPrint)
{
	int len = 0;
	DWORD notUsed = 0;
	time_t ltime;
	
	time(&ltime);

	_snprintf(logBuffer + len, 256 - len - 1, "[%s] : %s", msg, ctime(&ltime));	

	logBuffer[255]='\0';
	len = strlen(logBuffer);
	
	//printf("%s\n", 	buffer);
	WriteFile(logHandle, logBuffer, len, &notUsed, NULL);
	if (toPrint)
	{
		// we must synchronize this output, otherwise ...
		safePrintMessageA(logBuffer);					
	}
}


bool HttpServerWorker::init()
{
	bool hasError      = false;
	LPWSTR ptr         = NULL;
	hReqQueue          = NULL;
	threadHandle       = NULL;
	semaphore          = NULL;
	canStop            = false;
	isAssigned         = false;
	connectionId       = 0;
	
	requestBuffer      = NULL; 
	requestBufferSize  = 0;
	htmlBufferSize     = DefaultHtmlBufferSize;
	logHandle          = NULL;	

	semaphore          = NULL;

	if (!hasError)
	{
		semaphore=CreateSemaphore(NULL, 0, MaxPossibleResponseFromSingleConnection,	NULL);
		hasError = (semaphore == NULL);
	}
	
	if (!hasError)
	{		
		requestBuffer = (PHTTP_REQUEST)(calloc(DefaultRequestBufferSize, 1));
		hasError = 	(requestBuffer == NULL);   
	}

	if (!hasError)
	{
		if (fileList == NULL)
		{
			fileList = fopen("fileList.txt", "a+b");
			hasError = fileList == NULL;
		}
	}	
	if (! hasError)
	{
		if (fileListMutex == NULL)
		{
			fileListMutex = CreateMutex(NULL, FALSE, NULL);
			hasError = fileListMutex == NULL;
		}
	}

	if (! hasError)
	{
		hasError = ! GetModuleFileName(NULL, homePath, MAX_PATH * 4);
		if ((ptr = _tcsrchr(homePath, _T('\\')))!= NULL)
		{			
			*ptr = _T('\0');
		}
	}

	if (! hasError)
	{
		htmlBufferSize     = DefaultHtmlBufferSize;
		requestBufferSize  = DefaultRequestBufferSize;
	}

	return !hasError;
}

void HttpServerWorker::uninit()
{
	free(requestBuffer);
	fclose(fileList);
	CloseHandle(fileListMutex);
	CloseHandle(semaphore);
}


void HttpServerWorker::analysis()
{	
	char buffer[256];
	DWORD result = 0;
	retrieveAddress(requestBuffer->Address.pRemoteAddress, buffer);

	writeLogEntry(buffer, true);
}

void HttpServerWorker::convertNetworkPath(LPCTSTR filePath, LPTSTR fileName)
{
	LPCWSTR ptr = filePath;
	int offset = 0, counter = 0;
	_tcscpy(fileName, homePath);
	offset = _tcslen(fileName);
	while (counter < MY_MAX_PATH)
	{
		if (filePath[counter] == _T('/'))
		{
			fileName[offset + counter] = _T('\\');
		}
		else
		{
			fileName[offset + counter] = filePath[counter];
		}
		if (filePath[counter] == _T('\0'))
		{
			break;
		}
		counter ++;	
	}
}

bool HttpServerWorker::loadFile(LPCTSTR filePath, HTTP_RESPONSE& response, HTTP_DATA_CHUNK& dataChunk)
{
	FileFormat     imageFormat;
	TCHAR fileName[MAX_PATH];

	fileMapper.init();
	convertNetworkPath(filePath, fileName);
	if (! fileMapper.mapFile(fileName))
	{
		return false;
	}
	else
	{
		imageFormat = getFileFormat(fileMapper.imagePtr);
		switch (imageFormat)
		{
		case File_Format_BMP:
			ADD_KNOWN_HEADER(response, HttpHeaderContentType, "image/bmp");
			break;
		case File_Format_JPG:
			ADD_KNOWN_HEADER(response, HttpHeaderContentType, "image/jpeg");
			break;
		case File_Format_PNG:
			ADD_KNOWN_HEADER(response, HttpHeaderContentType, "image/png");
			break;
		case File_Format_TIF:
			ADD_KNOWN_HEADER(response, HttpHeaderContentType, "image/tif");
			break;
		case File_Format_GIF:
			ADD_KNOWN_HEADER(response, HttpHeaderContentType, "image/gif");
			break;	
		case File_Format_ZIP:
			ADD_KNOWN_HEADER(response, HttpHeaderContentType, "application/zip");
			break;
		case File_Format_RAR:
			ADD_KNOWN_HEADER(response, HttpHeaderContentType, "application/rar");
			break;
		case File_Format_MID:
			ADD_KNOWN_HEADER(response, HttpHeaderContentType, "media/midi");
			break;
		case File_Format_AVI:
			ADD_KNOWN_HEADER(response, HttpHeaderContentType, "application/avi");
			break;
		case File_Format_WAV:
			ADD_KNOWN_HEADER(response, HttpHeaderContentType, "media/wav");
			break;
		case File_Format_PDF:
			ADD_KNOWN_HEADER(response, HttpHeaderContentType, "application/pdf");
			break;
		case File_Format_ASF:
			ADD_KNOWN_HEADER(response, HttpHeaderContentType, "media/asf");
			break;
		case File_Format_MP3:
			ADD_KNOWN_HEADER(response, HttpHeaderContentType, "media/mp3");
			break;
		default:
			ADD_KNOWN_HEADER(response, HttpHeaderContentType, "text/html");
			break;
		}
		ADD_KNOWN_HEADER(response, HttpHeaderCacheControl, "max-age=99999999=9999999");
		dataChunk.FromMemory.pBuffer      = fileMapper.imagePtr;
		dataChunk.FromMemory.BufferLength = fileMapper.imageSize;
		return true;
	}
}


/*
void HttpServerWorker::handleGet(HTTP_RESPONSE& response, HTTP_DATA_CHUNK& dataChunk)
{
	static const   LPCTSTR ErrorMesssage = _T("unknown create entry page error");

	INITIALIZE_HTTP_RESPONSE(&response, 200, "ok");
	memcpy(&response.Version, &requestBuffer->Version, sizeof(HTTP_VERSION));
	ADD_KNOWN_HEADER(response, HttpHeaderContentType, "text/html");
	dataChunk.DataChunkType           = HttpDataChunkFromMemory;
	htmlBufferSize = DefaultHtmlBufferSize;
	if (createEntryPage(htmlBuffer, htmlBufferSize))
	{		
		dataChunk.FromMemory.pBuffer      = htmlBuffer;
		dataChunk.FromMemory.BufferLength = htmlBufferSize * sizeof(TCHAR);
	}
	else
	{
		response.StatusCode               = 400;  
		dataChunk.FromMemory.pBuffer      = (void*)ErrorMesssage;
		dataChunk.FromMemory.BufferLength = _tcslen(ErrorMesssage)*sizeof(TCHAR);
	}
}
*/

//assume searching for 29 "-" plus certain number of random string.
int HttpServerWorker::boundaryStringSearch(const char* src, const char* subStr, int srcLength, int subLength)
{
	//first let's search for 29 consecutive "-"
	int result = 0;
	int counter=0;
	
	//find first non "-" starting point
	while (src[result] == '-' && result < srcLength)
	{	
		for (counter =0; counter <29; counter++)
		{
			if (src[result+counter] != '-')
			{
				break;
			}
		}
		if (counter != 29)
		{
			result += counter;			
		}
		else
		{
			if (memcmp(src + result + 29, subStr, subLength) == 0)
			{
				return result;
			}
			else
			{
				result ++;
			}
		}
	}
	
	//so, we now know we start with non '-'
	while (result < srcLength)
	{
		//fast leap
		if (src[result] != '-' && src[result + 28] != '-')
		{
			result += 29;
		}
		else
		{
			if (src[result] != '-')
			{
				result ++;
			}
			else
			{
				for (counter = 0; counter < 29; counter++)
				{
					if (src[result + counter] != '-')
					{
						break;
					}
				}
				if (counter != 29)
				{
					result += counter;
				}
				else
				{
					if (memcmp(src + result + counter, subStr, subLength) == 0)
					{
						return result;
					}
					else
					{
						result ++;
					}
				}
			}
		}
	}
	//if we reach here, something is wrong.
	if (result >= srcLength)
	{
		return -1;
	}
}



bool HttpServerWorker::doRecvFile(LPTSTR fileName, LPSTR& imagePtr, DWORD& imageSize)
{
    bool           result = true;
	DWORD          retValue = 0;            
  
	unsigned long int byteRecved =0;  
	unsigned long int accumRecvedSize =0;
	unsigned long int totalFileSize=0;
	//char* buffer = NULL;
	char* curPtr = NULL, *ptr = NULL;
	int resultValue =0;
	bool isFirst = true;
	bool receiveBinaryData = false;
	int nameLength = 0;
	int fileStartOffset = 0, fileEndOffset = 0;
	char* boundaryStr  = NULL;
	char* fileStartPtr = NULL;
	int srcLength = 0;
	char* srcPtr = NULL;
	int offset = 0;
	int repeatId = 0;
	int i;
	//const char* HeaderStr1="Content-Disposition: form-data; name=\"";
	//const char* HeaderStr2="\";
	//filename=\"%s\" Content-Type: %s/%s\r\n\r\n";

	TCHAR inputName[MAX_PATH];

  	sscanf(requestBuffer->Headers.KnownHeaders[HttpHeaderContentLength].pRawValue, "%d", &totalFileSize);
	if (totalFileSize <= 0)
	{
		return false;
	}
	if ((imagePtr = (LPSTR)malloc(totalFileSize)) == NULL)
	{
		return result;
	}
	curPtr = imagePtr;

	do
	{
		result = true;
		resultValue = HttpReceiveRequestEntityBody(hReqQueue, requestBuffer->RequestId, 0,
			curPtr,  totalFileSize - accumRecvedSize, &byteRecved, NULL);
		switch (resultValue)
		{
		case NO_ERROR:
			result = true;
			break;
		default:
			result = false;
		}
		if (!result)
		{
			break;
		}  

		if (isFirst)
		{
			isFirst = false;
			ptr = curPtr;
			if (requestBuffer->Headers.KnownHeaders[HttpHeaderContentType].pRawValue == NULL)
			{
				receiveBinaryData = true;
				imageSize = totalFileSize;
				fileStartPtr = imagePtr;
				for (i = 0; i < MAX_PATH; i ++)
				{					
					_stprintf(fileName + i, _T("%c"), requestBuffer->pRawUrl[i]);
					if (requestBuffer->pRawUrl[i] == '\0')
					{
						break;
					}
				}				
			}
			else
			{
				boundaryStr = strstr(requestBuffer->Headers.KnownHeaders[HttpHeaderContentType].pRawValue,
					"boundary=");
				boundaryStr += 9;//strlen("boundary=");
				fileStartPtr = strstr((char*)ptr, boundaryStr);
				fileStartPtr += strlen(boundaryStr);
				fileStartPtr = strstr(fileStartPtr, "name=\"");
				fileStartPtr += 6;
				ptr = strchr(fileStartPtr, '"');
				
				strncpy((char*)inputName, fileStartPtr , ptr - fileStartPtr);
				fileStartPtr = strstr(ptr, "filename=\"");
				fileStartPtr += 10;
				ptr = strchr(fileStartPtr, '"');
				
			
				nameLength = RangeResult(ptr - fileStartPtr, 0, MAX_PATH - 1);
			
				for (i = 0; i < nameLength; i ++)
				{					
					_stprintf(fileName + i, _T("%c"), fileStartPtr[i]);
				}
				//fileName[(nameLength + 1)/sizeof(TCHAR)]='\0';			
				fileName[nameLength] = _T('\0');	
				
				
				fileStartPtr = strchr(ptr, ':');  
				
				fileStartPtr = strstr(ptr, "\r\n\r\n");
				fileStartPtr += 4;
				//skipSpace(fileStartPtr);
				//resultValue = sscanf(fileStartPtr, HeaderStr, inputName);//, fileName, typeName, subTypeName);
				//resultValue = sscanf(fileStartPtr, HeaderStr, inputName, fileName, typeName, subTypeName);
			}
		}			
		accumRecvedSize += byteRecved; 
		if (accumRecvedSize == totalFileSize)
		{
			break;
		}
		curPtr += 	byteRecved;
		//totalFileSize++;
	}
	while (accumRecvedSize < totalFileSize);
	if (result)
	{		 
		if ( !receiveBinaryData)
		{
			if (curPtr == imagePtr)
			{	
				srcPtr = fileStartPtr;
				srcLength = byteRecved - (fileStartPtr - imagePtr); 			
			}
			else
			{
				srcPtr = curPtr;   			
				srcLength = byteRecved;
			} 
			offset = boundaryStringSearch(srcPtr, boundaryStr + 27, srcLength, strlen(boundaryStr+27));
		
			result = (offset >= 0);
			if (result)
			{
				fileEndOffset = srcLength - offset + 2; //because of CLRF
				fileStartOffset = fileStartPtr - imagePtr;			 	
				
				//saveJpgFile(_T("mytest.jpg"), (LPBYTE)fileStartPtr, totalFileSize - fileStartOffset - 
				//	fileEndOffset);
				imageSize = totalFileSize - fileStartOffset - fileEndOffset;
			}
		}	
	}
	return result;
}

bool HttpServerWorker::generateFileName(LPCTSTR originalFileName, LPTSTR fileName)
{
	LPTSTR ptr;
	time_t mytime;
	struct tm* pTime = NULL;
	mytime = time(NULL);
	pTime = localtime(&mytime);

	ptr = _tcsrchr(originalFileName, _T('\\'));
	if (ptr == NULL)
	{
		ptr = _tcsrchr(originalFileName, _T('/'));	
	}

	if (ptr != NULL)
	{
		ptr ++;
	}
	else
	{
		ptr = (LPTSTR)originalFileName;
	}
	if (*ptr == _T('\0'))
	{
		ptr = _T("unknown");
	}


	_stprintf(fileName, _T("%s-%d-%d-%d-%d-%d-%d.jpg"), ptr, pTime->tm_year + 1900, 
		pTime->tm_mon, pTime->tm_mday, pTime->tm_hour, pTime->tm_min, pTime->tm_sec);
	return true;
}

bool HttpServerWorker::addToFileList(LPCTSTR fileName)
{
	DWORD result = 0;
	DWORD length = 0;
	result = WaitForSingleObject(fileListMutex, INFINITE);
	switch (result)
	{
	case WAIT_OBJECT_0:
		fseek(fileList, 0, SEEK_END);
		length = _tcslen(fileName);
		if (length == fwrite(fileName, sizeof(TCHAR), length, fileList))
		{
			if (fwrite(_T("\n"), sizeof(TCHAR), 1, fileList) == 1)
			{
				fflush(fileList);
			}
		}
		ReleaseMutex(fileListMutex);
		return true;
	default:
		return false;
	}
}

bool HttpServerWorker::recvFile()
{
	TCHAR originalFileName[MAX_PATH];
	TCHAR fileName[MAX_PATH];
	LPSTR imagePtr   = NULL;
	DWORD imageSize  = 0;
	if (doRecvFile(originalFileName, imagePtr, imageSize))
	{
		generateFileName(originalFileName, fileName);
		if (saveFile(fileName, imagePtr, imageSize))
		{
			if (addToFileList(fileName))
			{
				return true;
			}
		}
	}
	return false;
}

bool HttpServerWorker::createEntryPage(LPTSTR htmlBuffer, DWORD& htmlBufferSize)
{
	TCHAR fileName[MAX_PATH];
	DWORD waitRet = 0;
	DWORD offset  = 0, length = 0;
	time_t mytime;
	struct tm* pTime = NULL;

	waitRet = WaitForSingleObject(fileListMutex, INFINITE);
	switch (waitRet)
	{
	case WAIT_OBJECT_0:
		break;
	default:
		return false;
	}
	
	_stprintf(htmlBuffer + offset, _T("%s"), textBegin);
	offset = _tcslen(htmlBuffer);
	fseek(fileList, 0,  SEEK_SET);
	while (_fgetts(fileName, MAX_PATH, fileList))
	{
		length = _tcslen(fileName);
		//remove last linefeed
		if (fileName[length - 1]==_T('\n'))
		{
			fileName[length -1 ] = _T('\0');
			length --;
		}
		mytime = time(NULL);
		pTime = localtime(&mytime);
		_stprintf(htmlBuffer + offset, _T("<a href=\"%s\" target=\"_blank\">%s [%d-%d-%d %d:%d:%d]<br>"), fileName, 
			fileName, pTime->tm_year + 1900, pTime->tm_mon, pTime->tm_mday, pTime->tm_hour, 
			pTime->tm_min, pTime->tm_sec);
		//offset = _tcslen(htmlBuffer);
		offset = _tcslen(htmlBuffer);
	}
	_stprintf(htmlBuffer + offset, _T("%s"), textEnd);
	htmlBufferSize = _tcslen(htmlBuffer) * sizeof(TCHAR);

	ReleaseMutex(fileListMutex);
	return true;
}

void HttpServerWorker::handleResponse(HTTP_VERB action, HTTP_RESPONSE& response, HTTP_DATA_CHUNK& dataChunk)
{
	bool result = false;
	static const LPCTSTR ErrorMessage = _T("file uploading failed");
	LPSTR imagePtr = NULL;
	DWORD imageSize = 0;
	INITIALIZE_HTTP_RESPONSE(&response, 200, "ok");
	memcpy(&response.Version, &requestBuffer->Version, sizeof(HTTP_VERSION));
	
	dataChunk.DataChunkType           = HttpDataChunkFromMemory;

	switch (action)
	{
	case HttpVerbPOST:		
	case HttpVerbPUT:
		recvFile();
		break;
	case HttpVerbGET:
		if (_tcsicmp(requestBuffer->CookedUrl.pAbsPath, _T("/")) != 0)
		{		
			if (loadFile(requestBuffer->CookedUrl.pAbsPath, response, dataChunk))
			{
				result = true; 
			}
		}
		
		break;
	}
	
	if (! result)
	{
		ADD_KNOWN_HEADER(response, HttpHeaderContentType, "text/html");
		htmlBufferSize = DefaultHtmlBufferSize;
		if (createEntryPage(htmlBuffer, htmlBufferSize))
		{						
			dataChunk.FromMemory.pBuffer      = htmlBuffer;
			dataChunk.FromMemory.BufferLength = htmlBufferSize;
			result = true;
		}
	}

	if (! result)
	{
		response.StatusCode               = 400;  		
		dataChunk.FromMemory.pBuffer      = (void*) ErrorMessage;
		dataChunk.FromMemory.BufferLength = _tcslen(ErrorMessage) * sizeof(TCHAR);
	}
}

bool HttpServerWorker::sendHttpResponse()
{
    HTTP_RESPONSE   response;
    HTTP_DATA_CHUNK dataChunk;
    bool           result = false;
	DWORD          retValue = 0;            
    DWORD           bytesSent;
	char           msg[256];
	LPCWSTR        ptr = requestBuffer->CookedUrl.pAbsPath;

	handleResponse(requestBuffer->Verb, response, dataChunk);

	//_sntprintf(filePath, MY_MAX_PATH, _T("%s%s"), homePath, requestBuffer->CookedUrl.pAbsPath);
    
	response.EntityChunkCount         = 1;
    response.pEntityChunks            = &dataChunk;
	bytesSent=0;
	
    retValue = HttpSendHttpResponse(
                    hReqQueue,           // ReqQueueHandle
                    requestBuffer->RequestId, // Request ID                    
					0,
                    &response,           // HTTP response
                    NULL,                // pReserved1
                    &bytesSent,          // bytes sent   (OPTIONAL)
                    NULL,                // pReserved2   (must be NULL)
                    0,                   // Reserved3    (must be 0)
                    NULL,                // LPOVERLAPPED (OPTIONAL)
                    NULL                 // pReserved4   (must be NULL)
                    ); 

			
	sprintf(buf, "bytesSent %u, requestID=%I64u of connectionId %I64u ", bytesSent,
		requestBuffer->RequestId, requestBuffer->ConnectionId);
	//writeLogEntry(buf);
	safePrintMessageA(buf);

	fileMapper.uninit();

    if(retValue != NO_ERROR)
    {
        sprintf(msg, "HttpSendHttpResponse failed with %u", retValue);
		safePrintMessageA(msg);
		//writeLogEntry(buf);
		return false;
	}
	else
	{  		
		analysis(); 
		return true;
	}    
}


