/*++
 Copyright (c) 2002 - 2004 Microsoft Corporation.  All Rights Reserved.

 THIS CODE AND INFORMATION IS PROVIDED "AS-IS" WITHOUT WARRANTY OF
 ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO
 THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
 PARTICULAR PURPOSE.

 THIS CODE IS NOT SUPPORTED BY MICROSOFT. 

--*/
#include "stdafx.h"


FILE* MyHttpServer::log = NULL;

DWORD WINAPI ThreadProc(LPVOID param)
{
	HttpServerWorker* pWorker=(HttpServerWorker*)(param);

	while (true)
	{
		WaitForSingleObject(pWorker->semaphore, INFINITE);
		if (HttpServerWorker::canStop)
		{
			break;
		}	
		pWorker->sendHttpResponse();
		
		pWorker->isAssigned = false;		
	}	
	return 0;
}
	  
MyHttpServer::MyHttpServer()
{
	hReqQueue=NULL;
	log  = NULL;
}

void myHttpErrHandle(ULONG retCode)
{
	char msg[256];
	switch (retCode)
	{
	case ERROR_ACCESS_DENIED:
		safePrintMessageA("ERROR_ACCESS_DENIED: The calling application does not have permission to register the URL.");
		break;
	case ERROR_DLL_INIT_FAILED:
		safePrintMessageA("The calling application did not call HttpInitialize before calling this function.");
		break;
	case ERROR_INVALID_PARAMETER:
		safePrintMessageA("One of the parameters are invalid.");
		break;
	case ERROR_ALREADY_EXISTS:
		safePrintMessageA("The specified UrlPrefix conflicts with an existing registration.");
		break;
	case ERROR_NOT_ENOUGH_MEMORY:
		safePrintMessageA("Insufficient resources to complete the operation.");
		break;
	default:
		sprintf(msg, "A system error code defined in WinError.h. %u", retCode);
		safePrintMessageA(msg);
		break;
	}
}


bool MyHttpServer::init(WCHAR* myUrl)
{
	char fileName[32];
	ULONG retCode;
	int i;
	LPBYTE tempPtr = NULL;
    HTTPAPI_VERSION HttpApiVersion = HTTPAPI_VERSION_1;
	DWORD notUsed;

	if ((log =fopen("log.txt", "a+"))==NULL)
	{
		_tprintf(_T("cannot open log file! quit...\n"));
		return false;
	}

	if ((HttpServerWorker::printMutex = CreateMutex(NULL, FALSE, NULL))==NULL)
	{
		return false;
	}

	retCode = HttpInitialize(HttpApiVersion, HTTP_INITIALIZE_SERVER, NULL);

    if (retCode != NO_ERROR)
    {
        _ftprintf(log, _T("HttpInitialize failed with %lu \n"), retCode);
        return false;
    }
	retCode = HttpCreateHttpHandle(&hReqQueue, 0);
	
	if (retCode != NO_ERROR)
	{    
		_ftprintf(log, _T("HttpCreateHttpHandle failed with %lu \n"), retCode);
	
		return false;
	}

/*
	len  = _tcslen(myUrl);
	ZeroMemory(url, sizeof(url));
	for (i = 0; i <= len; i++)
	{
		url[i] = myUrl[i];
	}
	*/
	_stprintf(url, _T("%s"), myUrl); 

	retCode = HttpAddUrl(hReqQueue,  url, NULL);
	wprintf(L"%ws", url);

	if (retCode != NO_ERROR)
	{			
		_ftprintf(log, _T("HttpAddUrl failed with %lu \n"), retCode);
		myHttpErrHandle(retCode);
		retCode = HttpRemoveUrl(hReqQueue, url);
		
		return false;
	}
 

	for (i=0; i<MaxThreadNumber; i++)
	{
 		sprintf(fileName, "worker%d.txt", i);
		
		if ((workers[i].logHandle = CreateFileA(fileName, GENERIC_WRITE, FILE_SHARE_READ,
			NULL, OPEN_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL))==NULL)
		{
			_ftprintf(log, _T("worker %d cannot create worker file\n"), i);
			return false;
		}
		//this is necessary because "mysql" says "mysql_init" is not thread-safe

		if (!workers[i].init())
		{				
			return false;
		}		
	}

	HttpServerWorker::canStop = false;
   
	HttpServerWorker::hReqQueue = hReqQueue;

	for (i=0; i<MaxThreadNumber; i++)
	{
		workers[i].threadHandle=CreateThread(NULL, 0, ThreadProc, &workers[i], 0, &notUsed);
		workers[i].threadId = i;
		if (workers[i].threadHandle == NULL)
		{
			_ftprintf(log, _T("create thread %d failed of error %d\n"), i, GetLastError());
			return false;
		}
	}		
	return true;
}

void MyHttpServer::uninit()
{
	ULONG           retCode;
	int i;

	HttpServerWorker::canStop = true;

	for (i = 0; i < MaxThreadNumber; i ++)
	{
		if (workers[i].threadHandle != NULL)
		{
			WaitForSingleObject(workers[i].threadHandle, INFINITE);
		}		
		
		CloseHandle(workers[i].threadHandle);
		workers[i].uninit(); 
		if (workers[i].logHandle != NULL)
		{
			CloseHandle(workers[i].logHandle);
			workers[i].logHandle = NULL;
		}
	}

	retCode = HttpRemoveUrl(hReqQueue, url);

	if (retCode != NO_ERROR)
	{
		_ftprintf(log, _T("HttpAddUrl failed with %lu \n"), retCode);  
		myHttpErrHandle(retCode);
	}

	CloseHandle(hReqQueue);
 
	HttpTerminate(HTTP_INITIALIZE_SERVER, NULL); 
	fclose(log);
}

//int counter = 0;

DWORD MyHttpServer::work()
{
	ULONG              result;
    HTTP_REQUEST_ID    requestId;
    DWORD              bytesRead;
    PHTTP_REQUEST       pRequest; 
	int bufferSize;
	bool needNew = true;
	int tryCount;
	time_t ltime;
	int i, byteCount =0;
	char* pstr;
	TCHAR* ptstr;


	HTTP_SET_NULL_ID( &requestId );

    do
    {
		tryCount = 0;
		while ( needNew && !(bufferSize = retrieveWorker(pRequest)))
		{
			tryCount ++;  
			if (tryCount > 10)
			{
				return 0;
			}
			Sleep(1000);
		}

        RtlZeroMemory(pRequest, bufferSize);
		fflush(log);
        result = HttpReceiveHttpRequest(
                    hReqQueue,          // Req Queue
                    requestId,          // Req ID
                    HTTP_RECEIVE_REQUEST_FLAG_COPY_BODY,                  // Flags
                    pRequest,           // HTTP request buffer
                    bufferSize,// req buffer length
                    &bytesRead,         // bytes received
                    NULL                // LPOVERLAPPED
                    );
		time(&ltime);
		switch (result)
		{
		case NO_ERROR:     
            switch(pRequest->Verb)
            {
                case HttpVerbGET:
                    //_tprintf(_T("Got a GET request for %ws \n"), 
                    //        pRequest->CookedUrl.pFullUrl);
						 
					_ftprintf(log, _T("host[%ws] abspath[%ws] query[%ws]\n"), pRequest->CookedUrl.pHost, 
						pRequest->CookedUrl.pAbsPath, pRequest->CookedUrl.pQueryString);  
					_ftprintf(log, _T("time[%s] size[%d] chunkcount[%d]\n"), ctime(&ltime), 
						pRequest->BytesReceived, pRequest->EntityChunkCount); 
					_tprintf(_T("host[%ws] abspath[%ws] query[%ws]\n"), pRequest->CookedUrl.pHost, 
						pRequest->CookedUrl.pAbsPath, pRequest->CookedUrl.pQueryString);  
					printf("time:%s\n",  ctime(&ltime)); 

							
                    break;	 
                case HttpVerbPOST:
                    _ftprintf(log, _T("Got a POST request for %s \n"), 
                            pRequest->CookedUrl.pFullUrl); 
					
					_tprintf(_T("host[%s] abspath[%s] query[%s]\n"), pRequest->CookedUrl.pHost, 
						pRequest->CookedUrl.pAbsPath, pRequest->CookedUrl.pQueryString);  
					_tprintf(_T("time[%s] size[%d] chunkcount[%d]\n"), ctime(&ltime), 
						pRequest->BytesReceived, pRequest->EntityChunkCount); 

					_tprintf(_T("[%s]\n"), pRequest->pRawUrl); 

					_tprintf(_T("sizeof(http_request)[%d], actual size=%d\n"), 
						sizeof(HTTP_REQUEST), bytesRead); 

					pstr=(char*)pRequest + sizeof(HTTP_REQUEST);
					ptstr=(TCHAR*)pstr;
					for (i =0; i<42; i++)
					{
						byteCount += pRequest->Headers.KnownHeaders[i].RawValueLength;
						if (pRequest->Headers.KnownHeaders[i].RawValueLength !=0)
						{	 
							printf("header[%d], rawvalueLength=%d, %s\n", 
								i,  pRequest->Headers.KnownHeaders[i].RawValueLength,
								pRequest->Headers.KnownHeaders[i].pRawValue); 
						}
					}
					printf("\nbyteCount =%d\n************************\n\n", byteCount);	  
					//handlePost(hReqQueue, pRequest);
                    break;
                default:
                    _ftprintf(log, _T("Got a unknown request for %ws \n"), 
                            pRequest->CookedUrl.pFullUrl);                    
                    break;
            }
	
			notifyWorker(pRequest);	
			needNew = true;              
			break;   
        case ERROR_CONNECTION_INVALID:	
			if (!HTTP_IS_NULL_ID(&(pRequest->ConnectionId)))
			{
				//removeHttpRequest(pRequest);
				_ftprintf(log, _T("connection %I64u is lost, ignore...\n"), pRequest->ConnectionId);

				needNew = false;
			}
			else
			{
				_ftprintf(log, _T("got unknown error %d\n"), result);
				
			}
			break;
		default:
			_ftprintf(log, _T("got unknown error %d\n"), result);
			_tprintf(_T("got unknown error %d\n"), result);
			break;
		} 
    } 
	while (true);
    return result;
}

void MyHttpServer::handlePost(PHTTP_REQUEST pReq)
{
	
	
}

void MyHttpServer::waitForAllThreadIdle()
{
	bool succeed = true;
	int i;
	do
	{  		
		succeed = true;
		for (i = 0; i < MaxThreadNumber; i++)
		{
			if (workers[i].isAssigned)
			{
				succeed = false;
				Sleep(1000);
				break;
			}
		}
	}
	while (!succeed);
}

   
void MyHttpServer::notifyWorker(PHTTP_REQUEST pRequest)
{
	int i;
	for (i = 0; i < MaxThreadNumber; i++)
	{
		if (workers[i].requestBuffer == pRequest)
		{			
			ReleaseSemaphore(workers[i].semaphore, 1, NULL);
			return;
		}
	} 	
}


int MyHttpServer::retrieveWorker(PHTTP_REQUEST& pRequest)
{
	int i;
	while (true)
	{
		i = rand() % MaxThreadNumber;
	
		if (! workers[i].isAssigned)
		{				
		
			workers[i].isAssigned= true; 
			pRequest = workers[i].requestBuffer;
			return workers[i].requestBufferSize;  			
		}  
	} 

	return 0;
}



