
#define MY_MAX_PATH (MAX_PATH * 4)

typedef bool (* HandleFileCallBack)(_TCHAR* fullName, _TCHAR* fileName);

bool mapFile(const _TCHAR* fileName, LPBYTE& ptr, DWORD& size);
void unmapFile(LPBYTE ptr);

void genericFind(const _TCHAR* dir, HandleFileCallBack handleFileCallBack);

bool saveFile(LPCTSTR fileName, LPCSTR dest, DWORD size);

//bool generateUniqueFileName(LPTSTR buffer, int bufferSize);


class FileMapper
{
private:

public:
	WCHAR  fileName[MY_MAX_PATH];
	DWORD  lastAccessedTime;
	HANDLE fileHandle;
	HANDLE fileMapHandle;
	LPBYTE imagePtr;
	DWORD  imageSize;
	FileMapper();
	bool mapFile(LPCWSTR fileName);
	void init();
	void uninit();	
	~FileMapper();
};


const int MyFileHashTableSize = 30;


struct MyFileHashTable
{
	FileMapper fileMapper[MyFileHashTableSize];

	bool getFile(LPCTSTR path, LPBYTE& imagePtr, DWORD& imageSize);
//	~MyFileHashTable();
};
