#include "stdafx.h"

HANDLE fileHandle, fileMapHandle;

void genericFind(LPCWSTR dir, HandleFileCallBack handleFileCallBack)
{
	HANDLE handle;	
	WCHAR curFileName[MY_MAX_PATH];
	WCHAR wildFileName[MY_MAX_PATH];
	
	WIN32_FIND_DATA ffd;

	_sntprintf(wildFileName, MY_MAX_PATH, _T("%s\\*.*"), dir);
	handle=FindFirstFile(wildFileName, &ffd);
	if (handle==INVALID_HANDLE_VALUE)
	{
		_tprintf(_T("findfirst failed of error code =%d\n"), GetLastError());
		exit(19);
	}
	do
	{	
		if (_tcsicmp(ffd.cFileName, _T("."))!=0 && _tcsicmp(ffd.cFileName, _T(".."))!=0)
		{
			_stprintf(curFileName, _T("%s\\%s"), dir, ffd.cFileName);
			if  (GetFileAttributes(curFileName)&FILE_ATTRIBUTE_DIRECTORY)
			{
				genericFind(curFileName, handleFileCallBack);
			}
			else
			{					
				if (!handleFileCallBack(curFileName, ffd.cFileName))
				{
					break;
				}
			}
		}
	}
	while (FindNextFile(handle, &ffd));	
	
	FindClose(handle);
}

void FileMapper::init()
{
	imagePtr = NULL;
	imageSize = 0;
	fileName[0] = _T('\0');
	lastAccessedTime = 0;
}

FileMapper::FileMapper()
{
	init();
}

bool FileMapper::mapFile(LPCTSTR aFileName)
{
	bool result = false;
	if (aFileName != NULL)
	{
		if ((fileHandle = CreateFile(aFileName, GENERIC_READ, FILE_SHARE_READ, 
			NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL)) != INVALID_HANDLE_VALUE)
		{
			if ((fileMapHandle = CreateFileMapping(fileHandle, NULL, PAGE_READONLY, 0, 0, NULL)) != INVALID_HANDLE_VALUE)		
			{		
				if ((imagePtr = (LPBYTE)MapViewOfFile(fileMapHandle, FILE_MAP_READ, 0, 0, 0)) != NULL)
				{	
					if ((imageSize = GetFileSize(fileHandle, NULL)) != INVALID_FILE_SIZE)
					{
						result = true;
					}					
				}

			}
		}
		else
		{
			int err = GetLastError();
		}
	}
				
	if (! result)
	{
		uninit();
	}
	else
	{
		_tcscpy(fileName, aFileName);
		lastAccessedTime = GetTickCount();
	}
	return result;
}


void FileMapper::uninit()
{
	imageSize = 0;
	if (imagePtr != NULL)
	{
		UnmapViewOfFile(imagePtr);
		imagePtr = NULL;
	}
	if (fileMapHandle != NULL)
	{
		CloseHandle(fileMapHandle);
		fileMapHandle = NULL;
	}
	if (fileHandle != INVALID_HANDLE_VALUE)
	{
		CloseHandle(fileHandle);
		fileHandle = INVALID_HANDLE_VALUE;
	}
	fileName[0] = _T('\0');
	lastAccessedTime = 0;
}

FileMapper::~FileMapper()
{
	uninit();
}


// the least recently accessed
bool MyFileHashTable::getFile(LPCTSTR path, LPBYTE& imagePtr, DWORD& imageSize)
{
	bool repeated = false;
	bool result = false;
	int biggestValue = 0, biggestIndex = 0;;
	for (int i = 0; i < MyFileHashTableSize; i ++)
	{
		if (fileMapper[i].lastAccessedTime > biggestValue)
		{
			biggestValue = fileMapper[i].lastAccessedTime;
			biggestIndex = i;
		}
		if (_tcsicmp(fileMapper[i].fileName, path) == 0)
		{
			biggestIndex = i;
			repeated = true;
			break;
		}
	}
	if (!repeated)
	{
		fileMapper[biggestIndex].uninit();
		result = fileMapper[biggestIndex].mapFile(path);
	}
	else
	{
		//repeated means success
		result = true;
	}
	if (result)
	{
		imagePtr = fileMapper[biggestIndex].imagePtr;
		imageSize = fileMapper[biggestIndex].imageSize;		
	}
	return result;
}

	

bool saveFile(LPCTSTR fileName, LPCSTR dest, DWORD size)
{
	HANDLE fileHandle = NULL;
	DWORD tempSize = 0;
	bool result = true;
	if (dest == NULL)
	{
		return false;
	}
	if ((fileHandle = CreateFile(fileName, GENERIC_WRITE|STANDARD_RIGHTS_ALL, FILE_SHARE_READ, 
		 NULL, CREATE_NEW, FILE_ATTRIBUTE_NORMAL, NULL)) == INVALID_HANDLE_VALUE)
	{
		int err = GetLastError();
		return false;
	}
	if (!WriteFile(fileHandle, dest, size, &tempSize, NULL))
	{
		result = false;
	}
	CloseHandle(fileHandle);
	return result;
}

/*
bool generateUniqueFileName(LPTSTR buffer, int bufferSize)
{
	UUID uuid;	  
  	if (bufferSize < 33)
	{
		return false;
	}
	if (UuidCreate(&uuid) == RPC_S_OK)
	{
		_stprintf(buffer, _T("%X%X%X"), uuid.Data1, uuid.Data2, uuid.Data3);
		return true;
	} 
	return false;
}
*/