#include "stdafx.h"


void retrieveAddress(PSOCKADDR pSockAddress, char buffer[])
{
	PSOCKADDR_IN  pSock4;
	PSOCKADDR_IN6 pSock6;
	switch (pSockAddress->sa_family)
	{
	case AF_INET:
		pSock4 = (PSOCKADDR_IN) (pSockAddress);
		sprintf(buffer, "%u.%u.%u.%u:%u", pSock4->sin_addr.S_un.S_un_b.s_b1, 
			 pSock4->sin_addr.S_un.S_un_b.s_b2,  
			 pSock4->sin_addr.S_un.S_un_b.s_b3,
			  pSock4->sin_addr.S_un.S_un_b.s_b4, ntohs(pSock4->sin_port));
		break;

	case AF_INET6:
		pSock6 = (PSOCKADDR_IN6)(pSockAddress);
		for (int i=0; i<8; i++)
		{
			if (i == 0)
			{
				sprintf(buffer, "%u", pSock6->sin6_addr.s6_addr[0]);
			}
			else
			{
				sprintf(buffer + strlen(buffer), "%u", pSock6->sin6_addr.s6_addr[i]);
			}
		}  
		sprintf(buffer + strlen(buffer), ":%u", pSock6->sin6_port);
		break;
	}
}



void errHandle(ULONG res)
{
	switch (res)
	{
	case NO_ERROR:
		break;
	case ERROR_INVALID_PARAMETER:
		printf("ERROR_INVALID_PARAMETER\n");		
		break;
	case ERROR_INSUFFICIENT_BUFFER:
		printf("ERROR_INSUFFICIENT_BUFFER\n");
		break;
	case ERROR_MORE_DATA:
		printf("ERROR_MORE_DATA\n");
		break;
	case ERROR_HANDLE_EOF:
		printf("ERROR_HANDLE_EOF\n");
		break;
	default:
		printf("error of %d\n", res);
		break;
	}
}


void display(HTTP_REQUEST& request)
{
	printf("connectionID=%I64u\n", request.ConnectionId);
	printf("requestionID=%I64u\n", request.RequestId);
	switch (request.Verb)
	{
	case HttpVerbUnparsed:
		printf("HttpVerbUnparsedNot relevant for applications; used only in kernel mode.,\n");
		break;
	case HttpVerbUnknown:
		printf("HttpVerbUnknown\n");
		break;
	case HttpVerbInvalid:
		printf("HttpVerbInvalid	Not relevant for applications; used only in kernel mode.,\n");
		break;
	case HttpVerbOPTIONS:
		printf("HttpVerbOPTIONSThe OPTIONS method requests information about the communication\
			options  and requirements associated with a URI.\n");
		break;
	case HttpVerbGET:
		printf("HttpVerbGETThe GET method  retrieves the information or entity that is identified\
			by the URI of the Request. If that URI refers to a script or other data-producing \
			process, it is the data produced, not the text of the script, that is returned in \
			the response.A GET method can be made conditional or partial by including a \
			conditional  or Range header field in the request. A conditional GET requests that\
			the entity be sent only if all conditions specified in the header are met, and a \
			partial GET requests only part of the entity, as specified in the Range header. \
			Both of these forms of GET can help avoid unnecessary network traffic.\n");
		break;
	case HttpVerbHEAD:
		printf("HttpVerbHEADThe HEAD method is identical to GET except that the server only \
			returns message-headers in the response, without a message-body. The headers are\
			the same as would be returned in response to a GET.\n");
		break;
	case HttpVerbPOST:
		printf("HttpVerbPOSTThe POST method is used to post a new entity as an addition to  \
			a URI.The URI identifies an entity that  consumes the posted data in some fashion.\n");
		break;
	case HttpVerbPUT:
		printf("The PUT method is used to replace an entity identified by a URI.\n");
		break;
	case HttpVerbDELETE:
		printf("HttpVerbDELETEThe DELETE method requests that a specified URI be deleted.\n");
		break;
	case HttpVerbTRACE:
		printf("HttpVerbTRACEThe TRACE method invokes a remote, application-layer loop-back \
			of the request message.	It allows the client to see what is being received at the\
			other end of the request chain for diagnostic purposes.\n");
		break;
	case HttpVerbCONNECT:
		printf("HttpVerbCONNECTThe CONNECT method can be used with a proxy that can dynamically\
			switch to tunneling, as in the case of SSL tunneling. See page 57 of RFC 2616.,\n");
		break;
	case HttpVerbTRACK:
		printf("HttpVerbTRACK The TRACK method is used by Microsoft Cluster Server to implement\
			a non-logged trace.,\n");
		break;
	case HttpVerbMOVE:
		printf("HttpVerbMOVE The MOVE method requests a WebDAV operation equivalent to a copy \
			(COPY), followed by consistency maintenance   processing, followed by a delete of \
			the source, where all three actions are performed atomically. When applied to a\
			collection, 'Depth' is assumed to be or must be specified as 'infinity'. See page\n");
		break;
	case HttpVerbCOPY:
		printf("HttpVerbCOPYThe COPY method requests a WebDAV operation that creates a duplicate \
			of the source resource, identified by the Request URI, in the destination resource,\
			identified by a URI specified in the Destination header. See page 37 of RFC 2518.,\n");
		break;
	case HttpVerbPROPFIND:
		printf("HttpVerbPROPFIND the PROPFIND method requests a WebDAV operation that retrieves\
			properties defined on the resource identified by the Request-URI.\n");
		break;
	case HttpVerbPROPPATCH:
		printf("HttpVerbPROPPATCHThe PROPPATCH method requests a WebDAV operation that sets \
			and/or removes properties defined on the resource  identified by the Request-URI.\n");
		break;
	case HttpVerbMKCOL:
		printf("HttpVerbMKCOLThe MKCOL method requests a WebDAV operation that creates a new \
			collection resource at the location specified by the Request-URI.\n");
		break;
	case HttpVerbLOCK:
		printf("HttpVerbLOCK The LOCK method requests a  WebDAV operation that creates a lock \
			as specified by the lockinfo XML element on the Request-URI. \n");
		break;
	case HttpVerbUNLOCK:
		printf("HttpVerbUNLOCK The UNLOCK method requests a WebDAV operation that removes a \
			lock, identified by a lock token in  the Lock-Token request header, from the\
			resource identified by the Request-URI, and from all other resources included in \
			the lock. See page 51 of RFC 2518.,\n");
		break;
	case HttpVerbSEARCH:
		printf("HttpVerbSEARCHThe SEARCH method requests a WebDAV operation used by\
			Microsoft Exchange to search folders. See the Internet Engineering Task Force \
			(IETF) Internet Draft WebDAV SEARCH for more information, and the WebDAV Web site\
			for possible updates.,\n");
		break;
	case HttpVerbMaximum:
		printf("HttpVerbMaximumTerminates the enumeration; is not used to define a verb.\n");
		break;
	}
}



const BYTE BMP[2]   = {0x42, 0x4D};
const BYTE MP3[3] = {0x49, 0x44, 0x33};
const BYTE RM[4] = {0x2E, 0x52, 0x4D, 0x46};
const BYTE MPG[2] = {0xFF, 0xE0};
const BYTE TIF1[3] = {0x49, 0x49, 0x2A};
const BYTE TIF2[3] = {0x49, 0x20, 0x49};
const BYTE PDF[4] = {0x25, 0x50, 0x44, 0x46};
const BYTE JPG11[4] = {0xFF, 0xD8, 0xFF, 0xE0}; //, 0xE0 4A 46 49 46 00 app.FF D8 FF E0 
const BYTE JPG12[5] = {0x4A, 0x46, 0x49, 0x46, 0x00}; 
const BYTE JPG21[4] = {0xFF, 0xD8, 0xFF, 0xE1};
const BYTE JPG22[5] = {0x45, 0x78, 0x69, 0x66, 0x00};
const BYTE MID[4] = {0x4D, 0x54, 0x68, 0x64};
//const BYTE PPT[4] = {0xA0, 0x46, 0x1D, 0xF0}; //0F 00 E8 03

const BYTE PNG[8] = {0x89, 0x50, 0x4E, 0x47, 0x0D, 0x0A, 0x1A, 0x0A};
//47 49 46 38 37 61 
const BYTE GIF1[6] = {0x47, 0x49, 0x46, 0x38, 0x37, 0x61};
const BYTE GIF2[6] = {0x47, 0x49, 0x46, 0x38, 0x39, 0x61};

const BYTE ASF[16]= {0x30, 0x26, 0xB2, 0x75, 0x8E, 0x66, 0xCF, 0x11, 0xA6, 0xD9, 0x00, 0xAA, 0x00, 0x62, 0xCE, 0x6C};
const BYTE ZIP[4] = {0x50, 0x4B, 0x03, 0x04};
//const BYTE ZIP2[6]  = {0x50, 0x4B, 0x4C, 0x49, 0x54, 0x45};
//const BYTE ZIP3[5] = {0x50, 0x4B, 0x53, 0x70, 0x58};
//const BYTE ZIP4[6]= {0x57, 0x69, 0x6E, 0x5A, 0x69, 0x70};
const BYTE RAR[7] = {0x52, 0x61, 0x72, 0x21, 0x1A, 0x07, 0x00};

//52 49 46 46 xx xx xx xx 57 41 56 45 66 6D 74 20
const BYTE WAV1[4] = {0x52, 0x49, 0x46, 0x46};
const BYTE WAV2[8] = {0x57, 0x41, 0x56, 0x45, 0x66, 0x6D, 0x74, 0x20};

//const BYTE DOC[8] = {0xCF, 0x11, 0xE0, 0xA1, 0xB1, 0x1A, 0xE1, 0x00};
//52 49 46 46 xx xx xx xx 41 56 49 20 4C 49 53 54
const BYTE AVI1[4] = {0x52, 0x49, 0x46, 0x46};
const BYTE AVI2[8] = {0x41, 0x56, 0x49, 0x20, 0x4C, 0x49, 0x53, 0x54};

FileFormat getFileFormat(const LPBYTE image)
{
	unsigned short* src, * dst;
	src = (unsigned short*)MPG;
	dst = (unsigned short*)image;


	if (memcmp(image, BMP, 2) == 0)
	{
		return File_Format_BMP;
	}
	if (memcmp(image, MP3, 3) == 0)
	{
		return File_Format_MP3;
	}

	if ((*src & *dst) == *src)
	{
		return File_Format_MPG;
	}
	if (memcmp(image, RM, 4) == 0)
	{
		return File_Format_RM;
	}

	if (memcmp(image, PDF, 4) == 0)
	{
		return File_Format_PDF;
	}
	if (memcmp(image, MID, 4) == 0)
	{
		return File_Format_MID;
	}
	if (memcmp(image, PNG, 8) == 0)
	{
		return File_Format_PNG;
	}

	if (memcmp(image, GIF1, 6) == 0||memcmp(image, GIF2, 6) == 0)
	{
		return File_Format_GIF;
	}

	if (memcmp(image, RAR, 7) == 0 )
	{
		return File_Format_RAR;
	}

	if (memcmp(image, TIF1, 3) == 0 || memcmp(image, TIF2, 3) == 0)
	{
		return File_Format_TIF;
	}

	if (memcmp(image, ASF, 16) == 0)
	{
		return File_Format_ASF;
	}
	if (memcmp(image, ZIP, 4) == 0)
	{
		return File_Format_ZIP;
	}
	if (memcmp(image, JPG11, 4) == 0 && memcmp(image+6, JPG12, 5) == 0  ||
		memcmp(image, JPG21, 4) == 0 && memcmp(image+6, JPG22, 5) == 0  )
	{
		return File_Format_JPG;
	}
	if (memcmp(image, WAV1, 4) == 0 && memcmp(image+8, WAV2, 8) == 0)
	{
		return File_Format_WAV;
	}

	if (memcmp(image, AVI1, 4) == 0 && memcmp(image+8, AVI2, 8) == 0)
	{
		return File_Format_AVI;
	}

	return File_Format_UNKNOWN;
}
