#include <curl/curl.h>
#include <stdio.h>
#include <stdarg.h>
#include <map>
#include <string.h>
#include <time.h>
#include <string>
#include <sstream>
#include <iostream>
#include <openssl/evp.h>
#include <openssl/bio.h>
#include <openssl/hmac.h>

using namespace std;

typedef std::map<std::string, std::string> StringMap;
typedef std::pair<std::string, std::string> StringPair;
typedef StringMap::const_iterator StringMap_Iterator;

StringMap stringMap;
static char accessKey[32];
static char secretAccessKey[64];


int readKeyFile()
{
    FILE* fd = fopen("/home/nick/.ec2/s3key.txt", "r");
    if (fd)
    {
        fgets(accessKey, 32, fd);
        accessKey[strlen(accessKey) - 1]= '\0';
        fgets(secretAccessKey, 64, fd);
        secretAccessKey[strlen(secretAccessKey) - 1] = '\0';
        fclose(fd);
        return 0;
    }
    return -1;
}

std::string urlEncode(const std::string& aContent)
{
    std::string encoded;
    unsigned char c;
    unsigned char low, high;

    for (size_t i = 0; i < aContent.size(); i++)
    {
        c = aContent[i];
        if (isalnum(c)||(c == '-' || c == '_' || c == '.' || c == '~' || c == '+'))
        {
            encoded += c;
        }
        else
        {
            high = c / 16;
            low = c % 16;
            encoded += '%';
            encoded += (high < 10 ? '0' + high : 'A' + high - 10);
            encoded += (low < 10 ? '0' + low : 'A' + low - 10);
        }
    }
    return encoded;
}


std::string base64Encode(const char* aContent, size_t aContentSize)
{
    char* lEncodedString;
    long aBase64EncodedStringLength;

    // initialization for base64 encoding stuff
    BIO* lBio = BIO_new(BIO_s_mem());
    BIO* lB64 = BIO_new(BIO_f_base64());
    BIO_set_flags(lB64, BIO_FLAGS_BASE64_NO_NL);
    lBio = BIO_push(lB64, lBio);

    BIO_write(lBio, aContent, aContentSize);
    BIO_flush(lBio);
    aBase64EncodedStringLength = BIO_get_mem_data(lBio, &lEncodedString);

    // ensures null termination
    std::stringstream lTmp;
    lTmp.write(lEncodedString, aBase64EncodedStringLength);

    BIO_free_all(lBio);

    return lTmp.str(); // copy
}

void encrypt(const char* strToSign, unsigned int inLength, char* strSigned, unsigned int* pOutLength)
{
    HMAC_CTX    theHctx;
    HMAC_CTX_init(&theHctx);

    HMAC_Init(&theHctx, secretAccessKey, strlen(secretAccessKey), EVP_sha1());

    HMAC(EVP_sha1(), secretAccessKey, strlen(secretAccessKey), (const unsigned char *) strToSign, inLength, (unsigned char*)strSigned, pOutLength);
}

void input(int pairNumber, ...)
{
    va_list vl;
    va_start(vl, pairNumber);
    for (int i = 0; i < pairNumber; i ++)
    {
        char* strKey = va_arg(vl, char*);
        char* strValue = va_arg(vl, char*);
        stringMap.insert(StringPair(strKey, strValue));
    }
}

std::string getExpire()
{
    time_t after = time(NULL) + 300;
    char buffer[32];
    strftime(buffer, 32, "%FT%H:%M:%SZ", gmtime(&after));
    std::string in = buffer;
    return urlEncode(in);
}

std::string getTimestamp()
{
    time_t after = time(NULL);
    char buffer[32];
    strftime(buffer, 32, "%FT%H:%M:%SZ", gmtime(&after));
    std::string in = buffer;
    return urlEncode(in);
}

void outputHeader()
{
    for (StringMap_Iterator it = stringMap.begin(); it != stringMap.end(); it ++)
    {
        cout<<"key:"<<it->first<<";value:"<<it->second<<endl;
    }
}


size_t writeHeader( void *ptr, size_t size, size_t nmemb, void *stream)
{
    char buffer[1024];
    printf("size = %d, nmemb=%d\n", size, nmemb);
    for (int i = 0; i < size; i ++)
    {
        snprintf(buffer, nmemb, "%s", ptr);
        buffer[nmemb] = '\0';
        printf("header: %s\n", buffer);
    }

    return size * nmemb;
}

int curl_perform(const char* url)
{
    FILE* stream = fopen("mytest.txt", "w");
    CURL* pCurl = curl_easy_init( );
    curl_easy_setopt(pCurl, CURLOPT_VERBOSE, 1L);

    curl_easy_setopt(pCurl, CURLOPT_WRITEDATA, stream);
    curl_easy_setopt(pCurl, CURLOPT_HEADERFUNCTION, writeHeader);

    curl_easy_setopt(pCurl, CURLOPT_URL, url);

    curl_easy_perform(pCurl);

    curl_easy_cleanup(pCurl);

    fclose(stream);
}


void calcSignature(char* buffer, int& bufferLength)
{
    std::stringstream strStream;
    //char* GetString= "GET\nec2.amazonaws.com\n/\n";
    strStream << "GET"<<endl<<"ec2.amazonaws.com"<<endl<<"/"<<endl;
    bool isFirst = true;
    for (StringMap::iterator it = stringMap.begin(); it != stringMap.end(); it ++)
    {
        if (isFirst)
        {
            isFirst = false;
        }
        else
        {
            strStream<<"&";
        }
        strStream << it->first<<"="<<it->second;
    }
    char strSigned[1024];
    unsigned int length = 0;
    std::string str2sign = strStream.str();
    encrypt(str2sign.c_str(), str2sign.size(), strSigned, &length);
    std::string str = urlEncode(base64Encode(strSigned, length));
    strcpy(buffer, str.c_str());
    bufferLength = str.length();
}


std::string calcQuery()
{
    char* StringGet = "http://ec2.amazonaws.com";
    std::stringstream strStream;
    strStream << StringGet;
    StringMap::iterator it;
    it = stringMap.find("Action");
    strStream <<"/?Action="<<it->second;
    for (it = stringMap.begin(); it != stringMap.end(); it ++)
    {
        std::string key = it->first;
        if (strcmp(key.c_str(), "Action")!= 0)
        {
            strStream<<"&"<<it->first<<"="<<it->second;
        }
    }
    char buffer[1024];
    int bufferLength = 0;
    calcSignature(buffer, bufferLength);
    strStream<<"&Signature="<<buffer;
    return strStream.str();
}

char* AmazonEC2 = "http://ec2.amazonaws.com";

int main()
{
    char buffer[32];
    readKeyFile();
    //input(3, "ContentType", "text/html", "ContentLength", "50", "ContentEncoding", "utf8");
    std::string strExpire = getExpire();
    input(4, "SignatureMethod", "HmacSHA1", "SignatureVersion", "2", "AWSAccessKeyId", accessKey, "Action", "DescribeImages");
    input(2, "Expires", strExpire.c_str(), "Version", "2010-11-15");
    std::string url = calcQuery();
    curl_perform(url.c_str());
    //outputHeader();
    return 0;
}
