/* this is a -*-C++-*- file
 * Copyright (C) 2005 Wim Dumon
 *
 * See the LICENSE file for terms of use.
 */

#ifndef HANGMANGAME_H_
#define HANGMANGAME_H_

#include <Wt/WTable>
#include "LoginWidget.h"


namespace Wt
{
    class WStackedWidget;
    class WText;
    class WApplication;
}

using namespace Wt;

#include "Dictionary.h"

class HangmanWidget;
class HighScoresWidget;
class LoginWidget;


class HangmanGame : public WTable
{
    friend class LoginWidget;

public:
    HangmanGame(WContainerWidget *parent, WApplication* app);

private:

    enum GameChoice
    {
        LOGIN, PLAY, SCORE, UNKNOWN
    };
    GameChoice path2Choice(const std::string& path);
    std::string choice2Path(GameChoice choice);
    std::string      myPath;
    WApplication     *App;
    WStackedWidget   *MainStack;
    LoginWidget      *Login;
    HangmanWidget    *Game;
    HighScoresWidget *Scores;
    //WText            *BackToGameText;
    WText            *Title;
    WText            *MsgText;
    WPushButton      *PlayButton;
    WPushButton      *LoginButton;
    WPushButton      *ScoreButton;
    WText            *Path;
    std::wstring     User;
    Dictionary       Dict;
    bool             bLogin;

    void updateInternalPathByChoice(GameChoice choice);
    bool stateMachine(const std::string& path, GameChoice& target);
    void updateInternalPath();
    // Show the initial screen
    void login();
    void play();
    void score();
    void doLogin();
    void doPlay();
    void doScore();
};

#endif
