#ifndef DB_H_
#define DB_H_

#include <mysql++/mysql++.h>
#include <vector>
#include <string>



class HangmanDb
{
public:
    // this function returns false if user existed, true if user inserted
    // It guarantees atomic userExists() checking and adding it if the user
    // did not yet exits.
    bool addUser(const std::wstring &user, const std::wstring &password);

    // This function returns true when the credentials are found in the
    // database, otherwise false
    bool validLogin(const std::wstring &user, const std::wstring &pass);

    // Increments the number of games played, and adds delta to the score
    bool addToScore(const std::wstring &user, int delta);

    struct Score
    {
        int number; // position of the user
        std::wstring user;
        int numgames;
        int score;
        std::wstring lastseen; // Last seen, in GMT
    };

    // Returns the top n highest scoring users
    std::vector<Score> getHighScores(int top);

    // Returns the score structure for the given user
    int getUserPosition(const std::wstring &user);

    HangmanDb();

private:
    static mysqlpp::Connection con;
    static bool bConnected;
    bool getDBConnectionInfo(std::string&user, std::string& pass, int& port);
    //std::string DbUser();
    //static std::string DbPass();
};

#endif
