#include <iostream>
#include <iomanip>
#include <string>
#include <fstream>
//#include <mysql++/mysql++.h>
#include <vector>
#include <Wt/WStringUtil>
#include <Wt/WLogger>
#include <Wt/WApplication>
#include "HangmanDb.h"
#include <time.h>
#include <mysql++.h>
//#define MYSQLPP_SSQLS_NO_STATICS
#include <ssqls.h>
#include <openssl/md5.h>

using namespace mysqlpp;

sql_create_6(Hangman,
     1, 6,
     mysqlpp::sql_char, UserName,
     mysqlpp::sql_blob, Password,
     mysqlpp::sql_int, Rank,
     mysqlpp::sql_int, NumberOfGames,
     mysqlpp::sql_int, Scores,
     mysqlpp::sql_datetime, LastActivityDate)


using namespace mysqlpp;

Connection HangmanDb::con;
bool HangmanDb::bConnected = false;


bool HangmanDb::getDBConnectionInfo(std::string&user, std::string& pass, int& port)
{
    std::ifstream dbconf((Wt::WApplication::appRoot() + "HangmanDb.info").c_str());

    if (dbconf)
    {
        dbconf >> user;
        dbconf >> pass;
        dbconf >> port;
        return true;
    }
    return false;
}

HangmanDb::HangmanDb()
{
    try
    {
        if (!bConnected)
        {
            std::string user, pass;
            int port;
            if (getDBConnectionInfo(user, pass, port))
            {
                con.connect("hangman", "localhost", user.c_str(), pass.c_str(), port);
            }
        }
    }
    catch (Exception &e)
    {
        std::cerr << "Database exception!\n";
        std::cerr << e.what() << std::endl;
    }
}
// this function returns false if user existed, true if user inserted
// It guarantees atomic userExists() checking and adding it if the user
// did not yet exits.
bool HangmanDb::addUser(const std::wstring &user, const std::wstring &password)
{
    try
    {
        Hangman hangman;
        unsigned char digest[16];
        MD5((const unsigned char*)password.c_str(), password.size()*sizeof(wchar_t), digest);
        hangman.UserName= Wt::toUTF8(user);
        hangman.Password.assign((char*)digest, 16);
        hangman.Rank = -1;
        hangman.NumberOfGames = 1;
        hangman.Scores = 0;
        hangman.LastActivityDate.now();
        Query q = con.query();
        q.insert(hangman);
        q.exec();
        return q.affected_rows() == 1;
    }
    catch (Exception &e)
    {
        std::cerr << "Database exception!\n";
        std::cerr << e.what() << std::endl;
        return false;
    }
}


bool HangmanDb::validLogin(const std::wstring &user, const std::wstring &pass)
{
    try
    {
        unsigned char digest[16];
        MD5((const unsigned char*)pass.c_str(), pass.size()*sizeof(wchar_t), digest);
        std::string str;
        str.assign((char*)digest, 16);
        Query q = con.query();
        q << "select UserName, Password from Hangman where "
            << "UserName='" << Wt::toUTF8(user)
            << "' and Password='" <<mysqlpp::escape << str << "';";
        StoreQueryResult res = q.store();
        return res.size() > 0;
    }
    catch (Exception &e)
    {
        std::cerr << "Database exception!\n";
        std::cerr << e.what() << std::endl;
        return false;
    }
}

bool HangmanDb::addToScore(const std::wstring &user, int delta)
{
    try
    {
        Query q = con.query();
        q << "update Hangman set Scores=(Scores+(" << delta << ")), "
        << "NumberOfGames=(NumberOfGames+1), LastActivityDate=now() "
        << "where UserName='" << Wt::toUTF8(user) << "'";
        q.execute();
        return q.affected_rows() ==1;
    }
    catch (Exception &e)
    {
        std::cerr << "Database exception!\n";
        std::cerr << e.what() << std::endl;
        return false;
    }
}

std::vector<HangmanDb::Score> HangmanDb::getHighScores(int top)
{
    std::vector<HangmanDb::Score> retval;
    try
    {
        Query q = con.query();
        q << "select UserName, NumberOfGames, Scores, LastActivityDate from Hangman "
        << "order by Scores desc "
        << "limit " << top;
        std::vector<Hangman> res;
        q.storein(res);

        for (unsigned int i = 0; i < res.size(); ++i)
        {
            struct Score s;
            s.number = i + 1;
            s.user = Wt::fromUTF8((std::string)res.at(i).UserName);
            s.numgames = res.at(i).NumberOfGames;
            s.score = res.at(i).Scores;
            s.lastseen = Wt::fromUTF8((std::string)(res.at(i).LastActivityDate));
            retval.push_back(s);
        }
    }
    catch (Exception &e)
    {
        std::cerr << "Database exception!\n";
        std::cerr << e.what() << std::endl;
    }
    return retval;
}

int HangmanDb::getUserPosition(const std::wstring &user)
{
    int result = 0;
    try
    {
        Query q = con.query();
        q << "select count(*) as Rank from Hangman where Scores > (select Scores from Hangman where UserName=\""
            << Wt::toUTF8(user) << "\") order by Scores desc";
        StoreQueryResult res = q.store();
        result = res[0][0] + 1;

    }
    catch (Exception &e)
    {
        std::cerr << "Database exception!\n";
        std::cerr << e.what() << std::endl;
    }
    return result;
}
