#include <basetsd.h>
#include <http.h>
#include <stdio.h>
#include <winerror.h>
#include <TCHAR.h>
#include <mysql.h>
#include "mysqlClient.h"
#include "common.h"

#define RangeResult(x , low, high) (__max(low, __min(x, high)))

const unsigned int MaxMediaTypeCount = 2;
const unsigned int MaxThreadNumber= 5;
const unsigned int MaxPossibleResponseFromSingleConnection=100;//is it possible?
const unsigned int MaxRequestPoolSize=10;
const unsigned int DefaultRequestBufferSize=1024*2;

const unsigned int DefaultDataChunkCapacity = 1024*64;


extern void* selectPictureByIndex(int id, char*& ptr, int& length);
extern void* selectMediaDataByIndex(int mediaType, int id, char*& ptr, int& length);


extern void freeResult(void* res);



//static const TCHAR* urlPrefix=_T("http://192.168.2.11:80/");

static const TCHAR* textBegin=
_T("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\"\
        \"http://www.w3.org/TR/html4/strict.dtd\">\
<html>\
    <head>\
        <title>My first HTML document</title>\
    </head>\
    <body>\
		<form> \
        <p>The following pages contains mature material and nudity, viewer's discretion is \
		recommended. The purpose of this website is purely for research and the \
		contents do not represent web master's view.</p>\
        <p>This is my very first HTML page.</p>");



static const TCHAR* textEnd=
_T("<p>Some pages contains mature material and nudity, viewer's discretion is \
		recommended. The purpose of this website is purely for research and the \
		contents do not represent web master's view.</p>\
   <p><a  href=\"http://cid-893d817bb8a77bd7.skydrive.live.com/browse.aspx/MySQL+%20HTTP-Server%20|5purely%20C-implementation|6\"> The source code is here</a> </p>\
   </form>\
    </body>\
</html>");


const int MediaBatchNumber = 12;

const int CacheTableSize = MediaBatchNumber * 1;

struct MyHashTable
{
	int mediaType;	
	MyHashTable();
	int hash(int index);   
	int cacheTable[CacheTableSize];
	int sizeTable[CacheTableSize];
	void* sqlResTable[CacheTableSize];
	char* addressTable[CacheTableSize];
};


struct HttpServerWorker
{
	static int minMediaId[MaxMediaTypeCount];
	static int maxMediaId[MaxMediaTypeCount];
	static int maxMediaPage[MaxMediaTypeCount];	  	
  	
	MyHashTable myMediaHashTable[MaxMediaTypeCount];
	MyHashTable myThumbHashTable[MaxMediaTypeCount];

	MYSQL mysql;
	bool isConnected;
	static HANDLE	hReqQueue;
	static bool canStop;
 
	FILE* stream;
	int currentMediaId[MaxMediaTypeCount];
	int currentMediaPage[MaxMediaTypeCount];

	char myDatabaseIP[32];

	HANDLE threadHandle;
	HANDLE semaphore;
	int threadId;
	
	bool isAssigned;
	HTTP_CONNECTION_ID connectionId;
	//CRITICAL_SECTION  cs;	
	PHTTP_REQUEST requestBuffer; 
	int requestBufferSize;
	
	TCHAR htmlBuffer[4096];

	HttpServerWorker();
	bool init(TCHAR* dbAddress);
	void uninit();
	bool recoverFromDB();
	int hash(MyHashTable& hashTable, int id, bool isThumb);
	
	void createEntryPage(HTTP_DATA_CHUNK& dataChunk);
	void createPage(int mediaType, HTTP_DATA_CHUNK& dataChunk);
	bool getMediaData(int mediaType, HTTP_DATA_CHUNK& dataChunk, bool isThumb);
	void errHandle(const _TCHAR* reason);
	void* selectMediaDataByIndex(int mediaType, int id, char*& ptr, int& length, bool isThumb);
	void* selectPictureByIndex(int id, char*& ptr, int& length);
	void addSignature(_TCHAR* picture_name);
	int selectBatchPicture(int idStart, int number, char*results[], int lengths[]);
 
	bool doSendHttpResponse(int mediaType, HTTP_RESPONSE& response, 
									 HTTP_DATA_CHUNK& dataChunk, const TCHAR* action);
	bool sendHttpResponse();
	void analysis(int mediaType);
	
};


struct MyHttpServer
{
	TCHAR url[256];
	TCHAR	htmlBuffer[4096];
	HANDLE	hReqQueue;
	HttpServerWorker workers[MaxThreadNumber];
	bool init(TCHAR* url, TCHAR* dbIP);
	FILE* log;

	MyHttpServer();
	DWORD work();
	void notifyWorker(PHTTP_REQUEST request);
	int retrieveWorker(PHTTP_REQUEST& request);
	void notifyMaxConnection(PHTTP_REQUEST request);

	
	void waitForAllThreadIdle();

	bool initMediaDataRange(MYSQL* mysql, int mediaType, int& minId, 
		int& maxId, int& count);
	//void quit(int index);

	void uninit();
};



