/*++
 Copyright (c) 2002 - 2004 Microsoft Corporation.  All Rights Reserved.

 THIS CODE AND INFORMATION IS PROVIDED "AS-IS" WITHOUT WARRANTY OF
 ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO
 THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
 PARTICULAR PURPOSE.

 THIS CODE IS NOT SUPPORTED BY MICROSOFT. 

--*/
#include <time.h>
#include <basetsd.h>
#include <http.h>
#include <stdio.h>
#include <winerror.h>
#include <TCHAR.h>
#include "common.h"
#include "httpServer.h"
#include "mySqlClient.h"
#include <crtdbg.h>



#pragma comment(lib, "httpapi.lib")

int HttpServerWorker::minMediaId[MaxMediaTypeCount];
int HttpServerWorker::maxMediaId[MaxMediaTypeCount];
int HttpServerWorker::maxMediaPage[MaxMediaTypeCount];



HANDLE HttpServerWorker::hReqQueue = NULL;
bool HttpServerWorker::canStop = false;


DWORD WINAPI ThreadProc(LPVOID param)
{
	HttpServerWorker* pWorker=(HttpServerWorker*)(param);

	while (true)
	{
		WaitForSingleObject(pWorker->semaphore, INFINITE);
		if (HttpServerWorker::canStop)
		{
			break;
		}	
		if (pWorker->sendHttpResponse())
		{
			fflush(pWorker->stream);
			pWorker->isAssigned = false;
		}
		else
		{
			pWorker->isConnected = false;
		} 
	}	
	return 0;
}

MyHttpServer myHttpServer;

void uninit()
{
	myHttpServer.uninit();
}


int __cdecl _tmain(int argc, TCHAR * argv[])
{  	
	srand(time(0));
    if (argc != 3)
    {
        _tprintf(_T("%s: <Url> <database IP>\n"), argv[0]);
        return -1;
    } 
	
 
	_tprintf(_T("listening for requests on the following url: %s\n"), argv[1]);
	_tprintf(_T("database is in following ip: %s\n"), argv[2]);
	while (true)
	{
		__try
		{
			__try
			{
				if (myHttpServer.init(argv[1], argv[2]))
				{
					myHttpServer.work();
				}
			}
			__finally
			{
				myHttpServer.uninit();
			} 
		} 	
		__except(_tprintf(_T("exception occurred...\n")))
		{
			_tprintf(_T("exception has been handled...\n"));
		}
	}
	
    return 0;
}
	  
MyHttpServer::MyHttpServer()
{
	hReqQueue=NULL;
	log  = NULL;
}


bool MyHttpServer::init(TCHAR* myUrl, TCHAR* dbAddress)
{
	char fileName[32];
	ULONG retCode;
	int i;
    HTTPAPI_VERSION HttpApiVersion = HTTPAPI_VERSION_1;
	
	DWORD notUsed;

	if ((log =fopen("log.txt", "a+"))==NULL)
	{
		_tprintf(_T("cannot open log file! quit...\n"));
		return false;
	}
	retCode = HttpInitialize(HttpApiVersion, HTTP_INITIALIZE_SERVER, NULL);

    if (retCode != NO_ERROR)
    {
        _ftprintf(log, _T("HttpInitialize failed with %lu \n"), retCode);
        return false;
    }
	retCode = HttpCreateHttpHandle(&hReqQueue, 0);
	
	if (retCode != NO_ERROR)
	{    
		_ftprintf(log, _T("HttpCreateHttpHandle failed with %lu \n"), retCode);
	
		return false;
	}

	_stprintf(url, _T("%s"), myUrl);

	retCode = HttpAddUrl(hReqQueue,  url, NULL);

	if (retCode != NO_ERROR)
	{			
		_ftprintf(log, _T("HttpAddUrl failed with %lu \n"), retCode); 		
		return false;
	}
 
	HttpServerWorker::canStop = false;
   
	HttpServerWorker::hReqQueue = hReqQueue;

	for (i=0; i<MaxThreadNumber; i++)
	{
 		sprintf(fileName, "worker%d.txt", i);
		if ((workers[i].stream = fopen(fileName, "a+"))==NULL)
		{
			_ftprintf(log, _T("worker %d cannot create worker file\n"), i);
			return false;
		}
		//this is necessary because "mysql" says "mysql_init" is not thread-safe

		if (!workers[i].init(dbAddress))
		{				
			return false;
		}	
	}

	for (i=0; i<MaxMediaTypeCount; i++)
	{
		if (!initMediaDataRange(&workers[0].mysql, i, HttpServerWorker::minMediaId[i],
			HttpServerWorker::maxMediaId[i], HttpServerWorker::maxMediaPage[i]))
		{
			return false;
		}	
	}

	for (i=0; i<MaxThreadNumber; i++)
	{
		workers[i].threadHandle=CreateThread(NULL, 0, ThreadProc, &workers[i], 0, &notUsed);
		workers[i].threadId = i;
		if (workers[i].threadHandle == NULL)
		{
			_ftprintf(log, _T("create thread %d failed of error %d\n"), i, GetLastError());
			return false;
		}
	}		
	return true;
}

void MyHttpServer::uninit()
{
	ULONG           retCode;
	int i;

	HttpServerWorker::canStop=true;


	for (i = 0; i < MaxThreadNumber; i ++)
	{
		if (workers[i].threadHandle != NULL)
		{
			WaitForSingleObject(workers[i].threadHandle, INFINITE);
		}		
		
		CloseHandle(workers[i].threadHandle);
		workers[i].uninit();  
		fclose(workers[i].stream);
	}


	mysql_library_end();

	retCode = HttpRemoveUrl(hReqQueue, url);

	if (retCode != NO_ERROR)
	{
		_ftprintf(log, _T("HttpAddUrl failed with %lu \n"), retCode);    
	}

	CloseHandle(hReqQueue);
 
	HttpTerminate(HTTP_INITIALIZE_SERVER, NULL); 
	fclose(log);
}

//int counter = 0;

DWORD MyHttpServer::work()
{
	ULONG              result;
    HTTP_REQUEST_ID    requestId;
    DWORD              bytesRead;
    PHTTP_REQUEST       pRequest; 
	int bufferSize;
	bool needNew = true;
	int tryCount;


	HTTP_SET_NULL_ID( &requestId );

    do
    {
		tryCount = 0;
		while ( needNew && !(bufferSize = retrieveWorker(pRequest)))
		{
			tryCount ++;  
			if (tryCount > 10)
			{
				return 0;
			}
			Sleep(1000);
		}

        RtlZeroMemory(pRequest, bufferSize);
		fflush(log);
        result = HttpReceiveHttpRequest(
                    hReqQueue,          // Req Queue
                    requestId,          // Req ID
                    0,                  // Flags
                    pRequest,           // HTTP request buffer
                    bufferSize,// req buffer length
                    &bytesRead,         // bytes received
                    NULL                // LPOVERLAPPED
                    );	  
		switch (result)
		{
		case NO_ERROR:     
            switch(pRequest->Verb)
            {
                case HttpVerbGET:
                    //_tprintf(_T("Got a GET request for %ws \n"), 
                    //        pRequest->CookedUrl.pFullUrl);
					_ftprintf(log, _T("host[%ws] abspath[%ws] query[%ws]\n"), pRequest->CookedUrl.pHost, 
						pRequest->CookedUrl.pAbsPath, pRequest->CookedUrl.pQueryString);                    
					//_tprintf(_T("sizeof(http_request)[%d], actual size=%d\n"), 
					//	sizeof(HTTP_REQUEST), bytesRead);

                    break;

                case HttpVerbPOST:
                    _ftprintf(log, _T("Got a POST request for %ws \n"), 
                            pRequest->CookedUrl.pFullUrl);                   				
                    break;
                default:
                    _ftprintf(log, _T("Got a unknown request for %ws \n"), 
                            pRequest->CookedUrl.pFullUrl);                    
                    break;
            }
	
			notifyWorker(pRequest);	
			needNew = true ;
            
			break;   
        case ERROR_CONNECTION_INVALID:	
			if (!HTTP_IS_NULL_ID(&(pRequest->ConnectionId)))
			{
				//removeHttpRequest(pRequest);
				_ftprintf(log, _T("connection %I64u is lost, ignore...\n"), pRequest->ConnectionId);

				needNew = false;
			}
			else
			{
				_ftprintf(log, _T("got unknown error %d\n"), result);
				return result;
			}
			break;
		} 
    } 
	while (true);
    return result;
}

void MyHttpServer::waitForAllThreadIdle()
{
	bool succeed = true;
	int i;
	do
	{  		
		succeed = true;
		for (i = 0; i < MaxThreadNumber; i++)
		{
			if (workers[i].isAssigned)
			{
				succeed = false;
				Sleep(1000);
				break;
			}
		}
	}
	while (!succeed);
}

   
void MyHttpServer::notifyWorker(PHTTP_REQUEST pRequest)
{
	int i;
	for (i = 0; i < MaxThreadNumber; i++)
	{
		if (workers[i].requestBuffer == pRequest)
		{			
			ReleaseSemaphore(workers[i].semaphore, 1, NULL);
			return;
		}
	} 	
}


int MyHttpServer::retrieveWorker(PHTTP_REQUEST& pRequest)
{
	int i;
	while (true)
	{
		i = rand() % MaxThreadNumber;
	
		if (! workers[i].isAssigned)
		{				
			if (! workers[i].isConnected)
			{			
				if (! workers[i].recoverFromDB())
				{
					continue;
				}
			}
			else
			{
				workers[i].isAssigned= true; 
				pRequest = workers[i].requestBuffer;
				return workers[i].requestBufferSize;  
			}
		}  
	} 

	return 0;
}



void MyHttpServer::notifyMaxConnection(PHTTP_REQUEST pRequest)
{
    HTTP_RESPONSE   response;
    HTTP_DATA_CHUNK dataChunk;
    DWORD           result;
    DWORD           bytesSent;
	
	_stprintf(htmlBuffer, _T("%s<p> Maximum connection reached! Connect website later</p>%s"),
		textBegin, textEnd);


    INITIALIZE_HTTP_RESPONSE(&response, 200, "ok");

	dataChunk.DataChunkType=HttpDataChunkFromMemory;
	dataChunk.FromMemory.pBuffer=htmlBuffer;
	dataChunk.FromMemory.BufferLength=_tcsclen(htmlBuffer)*sizeof(TCHAR);

	memcpy(&response.Version, &pRequest->Version, sizeof(HTTP_VERSION));

	response.EntityChunkCount         = 1;
    response.pEntityChunks            = &dataChunk;
	memcpy(&response.Version, &pRequest->Version, sizeof(HTTP_VERSION));

	ADD_KNOWN_HEADER(response, HttpHeaderContentType, "text/html");

	bytesSent=sizeof(HTTP_RESPONSE)+dataChunk.FromMemory.BufferLength+sizeof(HTTP_DATA_CHUNK);
	
	
    result = HttpSendHttpResponse(
                    hReqQueue,           // ReqQueueHandle
                    pRequest->RequestId, // Request ID                    
					HTTP_SEND_RESPONSE_FLAG_DISCONNECT,	 					
                    &response,           // HTTP response
                    NULL,                // pReserved1
                    &bytesSent,          // bytes sent   (OPTIONAL)
                    NULL,                // pReserved2   (must be NULL)
                    0,                   // Reserved3    (must be 0)
                    NULL,                // LPOVERLAPPED (OPTIONAL)
                    NULL                 // pReserved4   (must be NULL)
                    ); 

			
	_ftprintf(log, _T("notify max connection: bytesSent %u, requestID=%I64u of connectionId %I64u \n"), 
		bytesSent, pRequest->RequestId, pRequest->ConnectionId);
    if(result != NO_ERROR)
    {
        _ftprintf(log, _T("notify max-connection HttpSendHttpResponse failed with %lu \n"), result);		
	}
}






