#include <basetsd.h>
#include <http.h>
#include <stdio.h>
#include <tchar.h>
#include <winerror.h>
#include "common.h"
#include "httpserver.h"
#include "md5.h"
#include "mySqlClient.h"
#include <time.h>



//audio/mpeg
const TCHAR* commentStr=
_T("<p>I changed back to original design because MySQL is not really trustworthy for thread-safe\
It is like window's service's 'appartment threading mode. Each thread running in its own space. \
The most siganificent improvement is the DB connection recovery. However, it is not fully tested.\
I hope visitors can help me test this. </p>");

const TCHAR* errorMessage = 
_T("<p> cannot find data in database</p>");

const TCHAR* MediaTypeLongName[2]=
{
	_T("image"),
	_T("music")
};

const TCHAR* MediaTypeShortName[2]=
{
	_T("img"),
	_T("embed")
};

ULONG result;


#define SAFE_CALL(X) if ((result=X)!=NO_ERROR) printf("error %u\n", result);


HttpServerWorker::HttpServerWorker()
{
	int i;
	hReqQueue = NULL;
	threadHandle       = NULL;
	semaphore          = NULL;
	canStop            = true;
	isConnected        = false;
	isAssigned         = false;
	connectionId       = 0;
	
	requestBuffer =NULL; 
	requestBufferSize  = 0;
	stream             = NULL;

	semaphore   = NULL;

	for (i = 0; i< MaxMediaTypeCount; i ++)
	{  
		currentMediaId[i] = 1;
		currentMediaPage[i] =  0;
		myMediaHashTable[i].mediaType=i;
	}		 
}
   
bool HttpServerWorker::recoverFromDB()
{
	int i, j;
	_ftprintf(stream, _T("attempt to recover from DB error\n"));
	for (i = 0; i < MaxMediaTypeCount; i++)
	{
		for (j = 0; j < CacheTableSize; j ++)
		{
			if (myMediaHashTable[i].sqlResTable[j] != NULL)
			{
				freeResult(myMediaHashTable[i].sqlResTable[j]);
			}
			myMediaHashTable[i].sqlResTable[j] = NULL;
		}
	}

	if (!connectDB(&mysql, myDatabaseIP))
	{
		_ftprintf(stream, _T("attempt to recover from DB failed\n"));
		return false;
	}
	_ftprintf(stream, _T("attempt to recover from DB succeeded\n"));
	return true;
}



void HttpServerWorker::analysis(int mediaType)
{	
	char buffer[64];
	time_t ltime;
	if (mediaType == -1)
	{
		return;
	}
	retrieveAddress(requestBuffer->Address.pRemoteAddress, buffer);

	time(&ltime);
	sprintf(buffer + strlen(buffer), " [%d] [%s", currentMediaId[mediaType], ctime(&ltime));
	buffer[strlen(buffer)-1]=']';
 	fprintf(stream, "%s\n",  buffer);
	fflush(stream);
	printf("%s\n", 	buffer);
}


	 
bool HttpServerWorker::init(TCHAR* dbAddress)
{
	int len;
	len = _tcsclen(dbAddress);
	for (int i = 0; i < len; i ++)
	{
		myDatabaseIP[i] = dbAddress[i];
	}

	//_tcscpy(myDatabaseIP, dbAddress);
	semaphore=CreateSemaphore(NULL, 0, MaxPossibleResponseFromSingleConnection,	NULL);
	if (semaphore == NULL)
	{
		return false;
	}
	
	//InitializeCriticalSection(&cs);
	

	if (!connectDB(&mysql, myDatabaseIP))
	{
		return false;
	}	

	isConnected = true;
	requestBuffer = (PHTTP_REQUEST)(new char[DefaultRequestBufferSize]);
	if (requestBuffer == NULL)
	{
		return false;
	}	
	requestBufferSize = DefaultRequestBufferSize;
	return true;
}

void HttpServerWorker::uninit()
{
	int i, j;
	delete[] requestBuffer;
	CloseHandle(semaphore);
	for (i = 0; i < MaxMediaTypeCount; i++)
	{
		for (j = 0; j < CacheTableSize; j ++)
		{
			if (myMediaHashTable[i].sqlResTable[j] != NULL)
			{
				freeResult(myMediaHashTable[i].sqlResTable[j]);
			}  			
		}
	}

	if (isConnected)
	{
		disconnectDB(&mysql); 
	}	 
}


int HttpServerWorker::hash(MyHashTable& hashTable, int id, bool isThumb)
{
	int index=id%CacheTableSize;  	
	if (id!=hashTable.cacheTable[index])
	{
		if (hashTable.cacheTable[index] != -1)
		{
			freeResult(hashTable.sqlResTable[index]);
		}
		hashTable.sqlResTable[index]=selectMediaDataByIndex(hashTable.mediaType, id, 
			hashTable.addressTable[index], hashTable.sizeTable[index], isThumb);
		if (hashTable.sqlResTable[index]==NULL)
		{
			hashTable.cacheTable[index]=-1;
			
			return -1;
		}
		hashTable.cacheTable[index]=id;		
	}	  	
	return index;
}


MyHashTable::MyHashTable()
{
	for (int i=0; i<CacheTableSize; i++)
	{
		cacheTable[i]=-1;
		addressTable[i]=NULL;
		sizeTable[i]=-1;
		sqlResTable[i]=NULL;
	}
}


void HttpServerWorker::errHandle(const _TCHAR* reason)
{
	_tprintf(_T("%s error %d\n"), reason, mysql_error(&mysql));
}


void HttpServerWorker::createEntryPage(HTTP_DATA_CHUNK& dataChunk)
{
	int len;
	//_stprintf(htmlBuffer, _T("%s <a href=\"image1\"> picture </a> &nbsp &nbsp &nbsp <a href=\"music1\">  music </a>"), textBegin);
	_stprintf(htmlBuffer, _T("%s <a href=\"image\"> picture </a> "), textBegin);
	len=_tcslen(htmlBuffer);
	_stprintf(htmlBuffer+len, _T("%s"), commentStr);
	len=_tcslen(htmlBuffer);
	_stprintf(htmlBuffer+len, _T("%s"), textEnd);	

	dataChunk.DataChunkType=HttpDataChunkFromMemory;
	dataChunk.FromMemory.pBuffer=htmlBuffer;
	dataChunk.FromMemory.BufferLength=_tcslen(htmlBuffer)*sizeof(TCHAR);	
}

void HttpServerWorker::createPage(int mediaType, HTTP_DATA_CHUNK& dataChunk)
{
	int i, len, batchNumber, currentId, currentPageNumber, index;
  
	len = 0;
	batchNumber       = MediaBatchNumber;
	currentId         = currentMediaId[mediaType];
	currentPageNumber = currentMediaPage[mediaType];

	
	_stprintf(htmlBuffer+len, _T("<table width=400 > <tr><td> <a href=\"%sprev%d\"> prev  </a></td>"),
		MediaTypeLongName[mediaType], __max(0, currentMediaPage[mediaType]-1));
	len=_tcslen(htmlBuffer);
	for (i = 1; i <= batchNumber; i++)
	{
		index = i+currentPageNumber*batchNumber;
		if (index > maxMediaId[mediaType] - minMediaId[mediaType])
		{
			break;
		}
		_stprintf(htmlBuffer+len, _T("<td><a href=\"%s%d\"> <img src=\"imagedatathumb%d\"> </a></td>"), 
			MediaTypeLongName[mediaType],			
			i+currentPageNumber*batchNumber, index);
		len=_tcslen(htmlBuffer);
	}
	_stprintf(htmlBuffer+len, _T("<td><a href=\"%snext%d\"> next </a></td></tr></table>"),
		MediaTypeLongName[mediaType], currentMediaPage[mediaType] + 1);

	len=_tcslen(htmlBuffer);

	_stprintf(htmlBuffer+len, _T("<p><%s  src=\"%sdata%d\"></p>"), MediaTypeShortName[mediaType],
		MediaTypeLongName[mediaType], currentId);	

	len=_tcslen(htmlBuffer);
	_stprintf(htmlBuffer +len, _T("%s"), textBegin);
	

	len=_tcslen(htmlBuffer);
	_stprintf(htmlBuffer+len, _T("%s"), textEnd);

	//_tprintf(_T("the html buffer is\n\n%s\n\n"), htmlBuffer);
	dataChunk.DataChunkType=HttpDataChunkFromMemory;
	dataChunk.FromMemory.pBuffer=htmlBuffer;
	dataChunk.FromMemory.BufferLength=_tcslen(htmlBuffer)*sizeof(TCHAR);
}


bool HttpServerWorker::getMediaData(int mediaType, HTTP_DATA_CHUNK& dataChunk, bool isThumb)
{
	int index;	
	dataChunk.DataChunkType=HttpDataChunkFromMemory;
	if (isThumb)
	{
		index=hash(myThumbHashTable[mediaType], currentMediaId[mediaType] + 
			minMediaId[mediaType] - 1, isThumb);	
	}
	else
	{
		index=hash(myMediaHashTable[mediaType], currentMediaId[mediaType] + 
			minMediaId[mediaType] - 1, isThumb);	
	}
	if (index == -1)
	{
		_ftprintf(stream, _T("get media data of %d failed\n"), currentMediaId[mediaType]);
		//should create error data page!!!
		//dataChunk.FromMemory.pBuffer = (void*)errorMessage;
		//dataChunk.FromMemory.BufferLength = _tcslen(errorMessage)*sizeof(TCHAR);

		return false;
	}
	if (isThumb)
	{
		dataChunk.FromMemory.pBuffer      = myThumbHashTable[mediaType].addressTable[index];
		dataChunk.FromMemory.BufferLength = myThumbHashTable[mediaType].sizeTable[index];
	}
	else
	{
		dataChunk.FromMemory.pBuffer      = myMediaHashTable[mediaType].addressTable[index];
		dataChunk.FromMemory.BufferLength = myMediaHashTable[mediaType].sizeTable[index];
	}

	return true;
}



bool HttpServerWorker::doSendHttpResponse(int mediaType, HTTP_RESPONSE& response, 
									 HTTP_DATA_CHUNK& dataChunk, const TCHAR* action)
{
	int id, result, pageId;
	bool isThumb;
	if (_tcsnicmp(action, _T("next"), 4)==0)
	{	
		_stscanf(action + 4, _T("%d"), &pageId);  
		currentMediaPage[mediaType] = RangeResult(pageId, 0, maxMediaPage[mediaType]-1);
	
		currentMediaId[mediaType] = 1 + currentMediaPage[mediaType] * MediaBatchNumber;
		

		createPage(mediaType, dataChunk);
		ADD_KNOWN_HEADER(response, HttpHeaderContentType, "text/html");	 		
	}
	else
	{
		if (_tcsnicmp(action, _T("prev"), 4)==0)
		{
			_stscanf(action + 4, _T("%d"), &currentMediaPage[mediaType]);  
			currentMediaPage[mediaType] = RangeResult(currentMediaPage[mediaType], 0, 
				maxMediaPage[mediaType]);
			
			currentMediaId[mediaType] = 1 + currentMediaPage[mediaType] * MediaBatchNumber ;


			createPage(mediaType, dataChunk);
			ADD_KNOWN_HEADER(response, HttpHeaderContentType, "text/html");
			
		}
		else
		{  			
			if (_tcsnicmp(action, _T("data"), 4)==0)
			{				
				switch (mediaType)
				{
				case 0:	 					
					ADD_KNOWN_HEADER(response, HttpHeaderContentType, "image/jpeg");
					//currentImageId=id;
					break;
				case 1:
					ADD_KNOWN_HEADER(response, HttpHeaderContentType, "audio/mpeg");
					//currentMusicId=id;
					break;
				}
				if (_tcsnicmp(action+_tcsclen(_T("data")), _T("thumb"), 5)==0)
				{			
					_stscanf(action + 4 + 5, _T("%d"), &id);

					isThumb = true;
				}
				else
				{
					_stscanf(action + 4, _T("%d"), &id);
					isThumb = false;		 
				}
				currentMediaId[mediaType]= RangeResult(id, 1, maxMediaId[mediaType]) ; 

				if (!getMediaData(mediaType, dataChunk, isThumb))
				{ 					
					return false; 				
				}					
			}
			else
			{
				result = _stscanf(action, _T("%d"), &id);
				if ( result !=  0 && result != EOF)
				{
					id = RangeResult(id, 1, maxMediaId[mediaType]);
					currentMediaPage[mediaType] = (id - 1) / MediaBatchNumber;
					currentMediaId[mediaType] = currentMediaPage[mediaType] *
						MediaBatchNumber + (id - 1)% MediaBatchNumber + 1;
				
					createPage(mediaType, dataChunk);

					ADD_KNOWN_HEADER(response, HttpHeaderContentType, "text/html");
				}
				else				
				{
					currentMediaPage[mediaType] = 
						rand()% (maxMediaPage[mediaType] / MediaBatchNumber - 1);
					currentMediaId[mediaType] = currentMediaPage[mediaType] *
						MediaBatchNumber + 1;
					createPage(mediaType, dataChunk);
					ADD_KNOWN_HEADER(response, HttpHeaderContentType, "text/html");
					
				}  		
			}
		}
	}
	return true;
}
 
bool HttpServerWorker::sendHttpResponse()
{
    HTTP_RESPONSE   response;
    HTTP_DATA_CHUNK dataChunk;
    bool           result = false;
	DWORD          retValue = 0;            
    DWORD           bytesSent;
	int mediaType = -1;


    INITIALIZE_HTTP_RESPONSE(&response, 200, "ok");
	memcpy(&response.Version, &requestBuffer->Version, sizeof(HTTP_VERSION));

	//_tprintf(_T("\n\nthe absPath=%s\n\n"), requestBuffer->CookedUrl.pAbsPath);
	if (requestBuffer->CookedUrl.pAbsPath==NULL)
	{
		createEntryPage(dataChunk);
		ADD_KNOWN_HEADER(response, HttpHeaderContentType, "text/html");
	}
	else
	{
		if (_tcsnicmp(requestBuffer->CookedUrl.pAbsPath, _T("/image"), 6)==0)
		{
			if (!doSendHttpResponse(0, response, dataChunk, requestBuffer->CookedUrl.pAbsPath+6))
			{
				return false;
			}
			mediaType = 0;
		}
		else
		{
			if (_tcsnicmp(requestBuffer->CookedUrl.pAbsPath, _T("/music"), 6)==0)
			{
				if (!doSendHttpResponse(1, response, dataChunk, requestBuffer->CookedUrl.pAbsPath+6))
				{
					return false;
				}
				mediaType = 1;
			}
			else
			{
				createEntryPage(dataChunk);
				ADD_KNOWN_HEADER(response, HttpHeaderContentType, "text/html");
			}
		}
	}   
	response.EntityChunkCount         = 1;
    response.pEntityChunks            = &dataChunk;
	bytesSent=0;
	
	
    retValue = HttpSendHttpResponse(
                    hReqQueue,           // ReqQueueHandle
                    requestBuffer->RequestId, // Request ID                    
					0,
                    &response,           // HTTP response
                    NULL,                // pReserved1
                    &bytesSent,          // bytes sent   (OPTIONAL)
                    NULL,                // pReserved2   (must be NULL)
                    0,                   // Reserved3    (must be 0)
                    NULL,                // LPOVERLAPPED (OPTIONAL)
                    NULL                 // pReserved4   (must be NULL)
                    ); 

			
	_ftprintf(stream, _T("bytesSent %u, requestID=%I64u of connectionId %I64u \n"), bytesSent,
		requestBuffer->RequestId, requestBuffer->ConnectionId);
    if(retValue != NO_ERROR)
    {
        _ftprintf(stream, _T("HttpSendHttpResponse failed with %u \n"), retValue);		
	}
	else
	{  		
		analysis(mediaType); 
	}

    return true;
}


void* HttpServerWorker::selectMediaDataByIndex(int mediaType, int id, char*& ptr, 
											   int& length, bool isThumb)
{
	char buffer[256];
	char* pDataField;
	int tryCount = 0;
	const int MaxTryCount = 3;
	bool queryError = false;
	MYSQL_ROW row;
	unsigned long * rowLengths;
	MYSQL_RES* res = NULL;
	switch (mediaType)
	{
	case 0:
		if (isThumb)
		{
			pDataField = "picture_thumb from mypicture";
		}
		else
		{
			pDataField = "picture_image from mypicture";
		}	 		
		break;
	case 1:
		pDataField = "music_data from mymusic";	 		
		break;
	}

	sprintf(buffer, "select %s where id=%d;", pDataField, id);


	do
	{
		if (!queryError)
		{
			if (mysql_real_query(&mysql, buffer, strlen(buffer)))
			{
				//_ftprintf(stream, _T("query error %d\n"), mysql_error(&mysql));	
				fprintf(stream, "query error %s\n", mysql_error(&mysql));	
				queryError = true;
			}
		}

		if (!queryError)
		{
			if ((res=mysql_store_result(&mysql))==NULL)
			{
				//_ftprintf(stream, _T("store result error %d\n"), mysql_error(&mysql));
				fprintf(stream, "store result error %s\n", mysql_error(&mysql));
				queryError = true;
			}
		}
		if (!queryError)
		{  
			if ((row=mysql_fetch_row(res))==NULL)
			{
				//_ftprintf(stream, _T("row error %d\n"), mysql_error(&mysql));
				fprintf(stream, "row error %s\n", mysql_error(&mysql));
				//queryError = true;
				//may not be error, just cannot find data!!!!
				return NULL;//cannot find data!!
			}
		}
		if (!queryError)
		{	
			if ((rowLengths=mysql_fetch_lengths(res))==NULL)
			{
				_ftprintf(stream, _T("row length error %d\n"), mysql_error(&mysql));  
				queryError = true;
			}
		}
	
		if (queryError)
		{
			if (!recoverFromDB())
			{
				_ftprintf(stream, _T("%d attempts failed to recover from DB error connection\n"),
					++tryCount);	
				Sleep(1000);
			}
			else
			{
				queryError = false;
			}			
		} 
		else
		{
			break;
		}
	}
	while (tryCount < MaxTryCount) ;

	if (queryError)
	{
		isConnected = false;
		return NULL;
	}

	ptr=row[0];
	length=rowLengths[0];
	return res;
}

void HttpServerWorker::addSignature(_TCHAR* picture_name)
{
	char buffer[256];
	int selectLength;
	MYSQL_ROW row;
	MYSQL_RES* res;
	unsigned long * lengths;
	unsigned char digest[16];
	const char* selectStatement="select picture_data from mypicture where picture_name=\"";
	sprintf(buffer, "%s", selectStatement);
	selectLength=strlen(selectStatement);
	_stprintf((_TCHAR*)(buffer+selectLength), _T("%s"), picture_name);
	selectLength=strlen(buffer);
	buffer[selectLength]='"';
	buffer[selectLength+1]='\0';

	if (mysql_real_query(&mysql, buffer, selectLength+1))
	{
		_ftprintf(stream, _T("query error %d picture_name=%s\n"), mysql_error(&mysql),
			picture_name);			
	}

	if ((res=mysql_store_result(&mysql))==NULL)
	{
		_ftprintf(stream, _T("store result error %d picture_name=%s\n"), mysql_error(&mysql),
			picture_name);
		return;
	}

	row=mysql_fetch_row(res);
	lengths=mysql_fetch_lengths(res);

	calculateMD5((unsigned char*)row[0], lengths[0], digest);
	for (int i=0; i<16; i++)
	{
		printf("%X", digest[i]);
	}
	mysql_free_result(res);
}

void* HttpServerWorker::selectPictureByIndex(int id, char*& ptr, int& length)
{
	char buffer[256];
	MYSQL_ROW row;
	unsigned long * rowLengths;
	MYSQL_RES* res;
	sprintf(buffer, "select picture_data from mypicture where id=%d;", id);
	if (mysql_real_query(&mysql, buffer, strlen(buffer)))
	{
		_ftprintf(stream, _T("query error %d\n"), mysql_error(&mysql));	
		return NULL;
	}

	if ((res=mysql_store_result(&mysql))==NULL)
	{
		_ftprintf(stream, _T("store result error %d\n"), mysql_error(&mysql));
		return NULL;
	}
	if ((row=mysql_fetch_row(res))==NULL)
	{
		_ftprintf(stream, _T("row error %d\n"), mysql_error(&mysql));

		return NULL;
	}

	if ((rowLengths=mysql_fetch_lengths(res))==NULL)
	{
		_ftprintf(stream, _T("row length error %d\n"), mysql_error(&mysql));

		return NULL;
	}
	ptr=row[0];
	length=rowLengths[0];
	return res;
}


int HttpServerWorker::selectBatchPicture(int idStart, int number, char*results[], int lengths[])
{
	int i;
	const char* selectStatement="select picture_data from mypicture where id";
	char buffer[256];
	MYSQL_ROW row;
	MYSQL_RES* res;
	unsigned long * rowLengths;
	sprintf(buffer, "%s between %d and %d;", selectStatement, idStart, idStart+number);
	if (mysql_real_query(&mysql, buffer, strlen(buffer)))
	{
		_ftprintf(stream, _T("query error %d\n"), mysql_error(&mysql));	
		return -1;
	}

	if ((res=mysql_store_result(&mysql))==NULL)
	{
		_ftprintf(stream, _T("store result error %d\n"), mysql_error(&mysql));
		return -1;
	}
	for (i=0; i<number; i++)
	{
		if ((row=mysql_fetch_row(res))==NULL)
		{
			_ftprintf(stream, _T("row  error %d\n"), mysql_error(&mysql));

			return i-1;
		}


		if ((rowLengths=mysql_fetch_lengths(res))==NULL)
		{
			_ftprintf(stream, _T("row length error %d\n"), mysql_error(&mysql));

			return i-1;
		}
		results[i]=row[0];
		lengths[i]=rowLengths[0];
	}
	return i;
}

bool MyHttpServer::initMediaDataRange(MYSQL* mysql, int mediaType, int& minId,
									  int& maxId, int& maxPage)
{
	char buffer[256];
	MYSQL_ROW row;
	unsigned long * rowLengths;
	MYSQL_RES* res;
	int count;

	sprintf(buffer, "select min(id), max(id), count(id) from %s ;", mediaType==0?"mypicture":"mymusic");

	if (mysql_real_query(mysql, buffer, strlen(buffer)))
	{
		_ftprintf(log, _T("query error %d\n"), mysql_error(mysql));	
		return false;
	}

	if ((res=mysql_store_result(mysql))==NULL)
	{
		_ftprintf(log, _T("store result error %d\n"), mysql_error(mysql));
		return false;
	}

	if ((row=mysql_fetch_row(res))==NULL)
	{
		_ftprintf(log, _T("row error %d\n"), mysql_error(mysql));

		return false;
	}

	if ((rowLengths=mysql_fetch_lengths(res))==NULL)
	{
		_ftprintf(log, _T("row length error %d\n"), mysql_error(mysql));

		return false;
	}
	sscanf( row[0], "%d", &minId);
	sscanf( row[1], "%d", &maxId);
	sscanf( row[2], "%d", &count);

	maxPage = (count + MediaBatchNumber - 1) / MediaBatchNumber;
	freeResult(res);
	return true;
}
