#include <basetsd.h>
#include <http.h>
#include <stdio.h>

#pragma comment(lib, "ws2_32.lib")

void retrieveAddress(PSOCKADDR pSockAddress, char buffer[])
{
	PSOCKADDR_IN  pSock4;
	PSOCKADDR_IN6 pSock6;
	switch (pSockAddress->sa_family)
	{
	case AF_INET:
		pSock4 = (PSOCKADDR_IN) (pSockAddress);
		sprintf(buffer, "%u.%u.%u.%u:%u", pSock4->sin_addr.S_un.S_un_b.s_b1, 
			 pSock4->sin_addr.S_un.S_un_b.s_b2,  
			 pSock4->sin_addr.S_un.S_un_b.s_b3,
			  pSock4->sin_addr.S_un.S_un_b.s_b4, ntohs(pSock4->sin_port));
		break;

	case AF_INET6:
		pSock6 = (PSOCKADDR_IN6)(pSockAddress);
		for (int i=0; i<8; i++)
		{
			if (i == 0)
			{
				sprintf(buffer, "%u", pSock6->sin6_addr.s6_addr[0]);
			}
			else
			{
				sprintf(buffer + strlen(buffer), "%u", pSock6->sin6_addr.s6_addr[i]);
			}
		}  
		sprintf(buffer + strlen(buffer), ":%u", pSock6->sin6_port);
		break;
	}
}

		

	


void errHandle(ULONG res)
{
	switch (res)
	{
	case NO_ERROR:
		break;
	case ERROR_INVALID_PARAMETER:
		printf("ERROR_INVALID_PARAMETER\n");		
		break;
	case ERROR_INSUFFICIENT_BUFFER:
		printf("ERROR_INSUFFICIENT_BUFFER\n");
		break;
	case ERROR_MORE_DATA:
		printf("ERROR_MORE_DATA\n");
		break;
	case ERROR_HANDLE_EOF:
		printf("ERROR_HANDLE_EOF\n");
		break;
	default:
		printf("error of %d\n", res);
		break;
	}
}


void display(HTTP_REQUEST& request)
{
	printf("connectionID=%I64u\n", request.ConnectionId);
	printf("requestionID=%I64u\n", request.RequestId);
	switch (request.Verb)
	{
	case HttpVerbUnparsed:
		printf("HttpVerbUnparsedNot relevant for applications; used only in kernel mode.,\n");
		break;
	case HttpVerbUnknown:
		printf("HttpVerbUnknown\n");
		break;
	case HttpVerbInvalid:
		printf("HttpVerbInvalid	Not relevant for applications; used only in kernel mode.,\n");
		break;
	case HttpVerbOPTIONS:
		printf("HttpVerbOPTIONSThe OPTIONS method requests information about the communication\
			options  and requirements associated with a URI.\n");
		break;
	case HttpVerbGET:
		printf("HttpVerbGETThe GET method  retrieves the information or entity that is identified\
			by the URI of the Request. If that URI refers to a script or other data-producing \
			process, it is the data produced, not the text of the script, that is returned in \
			the response.A GET method can be made conditional or partial by including a \
			conditional  or Range header field in the request. A conditional GET requests that\
			the entity be sent only if all conditions specified in the header are met, and a \
			partial GET requests only part of the entity, as specified in the Range header. \
			Both of these forms of GET can help avoid unnecessary network traffic.\n");
		break;
	case HttpVerbHEAD:
		printf("HttpVerbHEADThe HEAD method is identical to GET except that the server only \
			returns message-headers in the response, without a message-body. The headers are\
			the same as would be returned in response to a GET.\n");
		break;
	case HttpVerbPOST:
		printf("HttpVerbPOSTThe POST method is used to post a new entity as an addition to  \
			a URI.The URI identifies an entity that  consumes the posted data in some fashion.\n");
		break;
	case HttpVerbPUT:
		printf("The PUT method is used to replace an entity identified by a URI.\n");
		break;
	case HttpVerbDELETE:
		printf("HttpVerbDELETEThe DELETE method requests that a specified URI be deleted.\n");
		break;
	case HttpVerbTRACE:
		printf("HttpVerbTRACEThe TRACE method invokes a remote, application-layer loop-back \
			of the request message.	It allows the client to see what is being received at the\
			other end of the request chain for diagnostic purposes.\n");
		break;
	case HttpVerbCONNECT:
		printf("HttpVerbCONNECTThe CONNECT method can be used with a proxy that can dynamically\
			switch to tunneling, as in the case of SSL tunneling. See page 57 of RFC 2616.,\n");
		break;
	case HttpVerbTRACK:
		printf("HttpVerbTRACK The TRACK method is used by Microsoft Cluster Server to implement\
			a non-logged trace.,\n");
		break;
	case HttpVerbMOVE:
		printf("HttpVerbMOVE The MOVE method requests a WebDAV operation equivalent to a copy \
			(COPY), followed by consistency maintenance   processing, followed by a delete of \
			the source, where all three actions are performed atomically. When applied to a\
			collection, 'Depth' is assumed to be or must be specified as 'infinity'. See page\n");
		break;
	case HttpVerbCOPY:
		printf("HttpVerbCOPYThe COPY method requests a WebDAV operation that creates a duplicate \
			of the source resource, identified by the Request URI, in the destination resource,\
			identified by a URI specified in the Destination header. See page 37 of RFC 2518.,\n");
		break;
	case HttpVerbPROPFIND:
		printf("HttpVerbPROPFIND the PROPFIND method requests a WebDAV operation that retrieves\
			properties defined on the resource identified by the Request-URI.\n");
		break;
	case HttpVerbPROPPATCH:
		printf("HttpVerbPROPPATCHThe PROPPATCH method requests a WebDAV operation that sets \
			and/or removes properties defined on the resource  identified by the Request-URI.\n");
		break;
	case HttpVerbMKCOL:
		printf("HttpVerbMKCOLThe MKCOL method requests a WebDAV operation that creates a new \
			collection resource at the location specified by the Request-URI.\n");
		break;
	case HttpVerbLOCK:
		printf("HttpVerbLOCK The LOCK method requests a  WebDAV operation that creates a lock \
			as specified by the lockinfo XML element on the Request-URI. \n");
		break;
	case HttpVerbUNLOCK:
		printf("HttpVerbUNLOCK The UNLOCK method requests a WebDAV operation that removes a \
			lock, identified by a lock token in  the Lock-Token request header, from the\
			resource identified by the Request-URI, and from all other resources included in \
			the lock. See page 51 of RFC 2518.,\n");
		break;
	case HttpVerbSEARCH:
		printf("HttpVerbSEARCHThe SEARCH method requests a WebDAV operation used by\
			Microsoft Exchange to search folders. See the Internet Engineering Task Force \
			(IETF) Internet Draft WebDAV SEARCH for more information, and the WebDAV Web site\
			for possible updates.,\n");
		break;
	case HttpVerbMaximum:
		printf("HttpVerbMaximumTerminates the enumeration; is not used to define a verb.\n");
		break;
	}
}
