#include "stdafx.h"


char* DefaultHost="76.69.228.24";
const char* DefaultUser="root";
const char* DefaultPassword="202409";
const char* DefaultDatabase="nicktest";
const int DefaultPort=3306;


MySqlTools::~MySqlTools()
{
	mysql_close(&mysql);
	fclose(log);
}


bool MySqlTools::saveToFile(int offset)
{
	bool result = false;
	LPBYTE imagePtr;
	DWORD imageSize;
	int imageWidth;
	int imageHeight;
	int stretchedWidth;
	int stretchedHeight;
	LPBYTE thumbPtr;
	LPBYTE stretchedPtr;
	DWORD thumbDataSize;
	DWORD stretchedSize;
	int fileFormat;
	int id;

	id = minId + offset;
	
	if (fetchData(id, imagePtr, imageSize))
	{
		fileFormat=imageFileFormat(imagePtr);
		if (imageProcess(imagePtr, imageSize, DefaultMaxHeight, DefaultThumbnailSize,
			imageWidth, imageHeight, stretchedWidth, stretchedHeight, thumbPtr, 
			stretchedPtr, thumbDataSize, stretchedSize) == JPEG_SUCCESS)
		{
			saveJpgFile(_T("original.jpg"), imagePtr, imageSize);	 
			saveJpgFile(_T("stretched.jpg"), stretchedPtr, stretchedSize);
			saveJpgFile(_T("thumbnail.jpg"), thumbPtr, thumbDataSize);
			_ftprintf(log, _T("imageSize[%d], maxHeight[%d],thumbSize[%d],imageWidth[%d],\
			  imageHeight[%d], stretchedWidth[%d], stretchedHeight[%d], thumbDataSize[%d],\
			  stretchedSize[%d]\n"), imageSize, DefaultMaxHeight, DefaultThumbnailSize,
			  imageWidth, imageHeight,
			  stretchedWidth, stretchedHeight, thumbDataSize, stretchedSize);
			free(stretchedPtr);
			free(thumbPtr);
			result = true;
		}
		free(imagePtr);
	}
	return result;

}


bool MySqlTools::init(char* ipAddress)
{
	char* host = ipAddress;
	if ((log = fopen("mysql.log", "a+"))==NULL)
	{
		return false;
	}

	mysql_init(&mysql);
	if (ipAddress == NULL)
	{
		host = DefaultHost;
	}
	if (mysql_init(&mysql)==NULL)
	{
		return false;
	}
	if (mysql_real_connect(&mysql, host, DefaultUser, DefaultPassword,
		DefaultDatabase, DefaultPort, NULL, 0)==NULL)
	{
		mysql_close(&mysql);
		return false;
	}
	if (!initDataRange(minId, maxId, count))
	{
		mysql_close(&mysql);
		return false;
	}

	return true;
}



bool MySqlTools::initDataRange( int& minId, int& maxId, int& count)
{
	char buffer[256];
	MYSQL_ROW row;
	MYSQL_RES* res=NULL;	  

	sprintf(buffer, "select min(id), max(id), count(id) from mypicture");

	if (doFetchResult(buffer, res))
	{	
		if ((row=mysql_fetch_row(res))==NULL)
		{
			_ftprintf(log, _T("row error %d\n"), mysql_error(&mysql));
			mysql_free_result(res);
			return false;
		}

		sscanf( row[0], "%d", &minId);
		sscanf( row[1], "%d", &maxId);
		sscanf( row[2], "%d", &count);

		mysql_free_result(res);	
		return true;
	}
	return false;
}

bool MySqlTools::doforeach(int id, const LPBYTE imagePtr, DWORD imageSize)
{
	bool isSucceed = false;
 	int imageWidth  = 0;
	int imageHeight = 0;
	int stretchedWidth = 0;;
	int stretchedHeight = 0;
	LPBYTE thumbPtr     = NULL;
	LPBYTE stretchedPtr = NULL;
	DWORD thumbDataSize = 0;
	DWORD stretchedDataSize = 0;

	if (imageProcess(imagePtr, imageSize, DefaultMaxHeight, DefaultThumbnailSize,
				imageWidth, imageHeight, stretchedWidth,  stretchedHeight, thumbPtr,
				stretchedPtr, thumbDataSize,stretchedDataSize) == JPEG_SUCCESS)
	{
		isSucceed = true;
		if (isSucceed)
		{
			isSucceed = updateInt(id, imageWidth, "picture_width");
		}
		if (isSucceed)
		{
			isSucceed = updateInt(id, imageHeight, "picture_height");
		}
		if (isSucceed)
		{
			isSucceed = updateInt(id, stretchedWidth, "picture_image_width");
		}
		if (isSucceed)
		{
			isSucceed = updateInt(id, stretchedHeight, "picture_image_Height");
		}

		if (isSucceed)
		{
			isSucceed = updateInt(id, thumbDataSize, "picture_thumb_size");
		}

		if (isSucceed)
		{
			isSucceed = updateInt(id, stretchedDataSize, "picture_image_size");
		}

		if (isSucceed)
		{
			isSucceed = updateBinary(id, stretchedPtr, stretchedDataSize, "picture_image");
		}
		if (isSucceed)
		{
			isSucceed = updateBinary(id, thumbPtr, thumbDataSize, "picture_thumb");
		}
		
		free(stretchedPtr); 
		free(thumbPtr);
	}
	return isSucceed;
}



bool MySqlTools::foreach(int offset)
{
	int succeeded = 0;
	int id = minId + offset;
	LPBYTE imagePtr  = NULL;
	DWORD  imageSize = 0;  

	while (id < maxId)
	{ 		
		if (fetchData(id, imagePtr, imageSize))
		{
			if (!doforeach(id, imagePtr, imageSize))
			{
				_ftprintf(log, _T("image process error of id[%d]\n"), id);
			}
			else
			{
				succeeded ++;
			}
			free(imagePtr); 
		} 
		id ++;
		if (id % 10 == 0)
		{
			_tprintf(_T("id = %d, succeeded = %d\n"), id, succeeded);
		}
		fflush(log);
	}
	_ftprintf(log, _T("expected [%d], actually [%d]\n"), count, succeeded);

	return succeeded == count;
}

bool MySqlTools::fetchData(int id, LPBYTE& imagePtr, DWORD& imageSize)
{
	char buffer[256];
	MYSQL_ROW row;
	unsigned long * lengths;
	MYSQL_RES* res=NULL;	  

	sprintf(buffer, "select picture_data from mypicture where id = %d", id);

	if (doFetchResult(buffer, res))
	{	
		if ((row=mysql_fetch_row(res))==NULL)
		{
			_ftprintf(log, _T("row error %s\n"), mysql_error(&mysql));
			mysql_free_result(res);
			return false;
		}  

		if ((lengths=mysql_fetch_lengths(res))==NULL)
		{
			_ftprintf(log, _T("row length error %s\n"), mysql_error(&mysql));
			mysql_free_result(res);	 
			return false;
		}
		imageSize = lengths[0];
		imagePtr = (LPBYTE)malloc(imageSize);
		if (imagePtr == NULL)
		{
			_ftprintf(log, _T("allocate memory faile for %d bytes\n"), imageSize);
			mysql_free_result(res);	 
			return false;  
		}
		memcpy(imagePtr, row[0], imageSize);
		mysql_free_result(res);	
		return true;
	}
	return false;	 	
}


bool MySqlTools::doFetchResult(const char* statement, MYSQL_RES*& res)
{
	if (mysql_real_query(&mysql, statement, strlen(statement)))
	{
		_ftprintf(log, _T("query error %s\n"), mysql_error(&mysql));	
		return false;
	}

	if ((res=mysql_store_result(&mysql))==NULL)
	{
		_ftprintf(log, _T("store result error %s\n"), mysql_error(&mysql));			
		return false;
	}
	return true;
}



bool MySqlTools::updateInt(int id, int data, char* field, char* table)
{
	char buffer[256];
	sprintf(buffer, "update %s set %s=%d where %s = %d", table, field, data, "id", id);

	if (mysql_real_query(&mysql, buffer, strlen(buffer)))
	{
		_ftprintf(log, _T("query error %s\n"), mysql_error(&mysql));	
		return false;
	}
	return true;
}

bool MySqlTools::updateBinary(int id, LPBYTE data, int size, char* field, char* table)
{
	char* buffer = NULL;
	int len, escapeLength;

	buffer = (char*)malloc(size*2 + 256);
	if (buffer == NULL)
	{
		return false;
	}
	sprintf(buffer, "update %s set %s =\"", table, field);
	len = strlen(buffer);
	if ((escapeLength = mysql_real_escape_string(&mysql, buffer + len, (char*)data, size))
		==0)
	{
		free(buffer);
		return false;
	}
	len += escapeLength;
	sprintf(buffer+len, "\" where id = %d", id);
	len += strlen(buffer+len);

	if (mysql_real_query(&mysql, buffer, len))
	{  
		_ftprintf(log, _T("query error %s\n"), mysql_error(&mysql)); 		
		free(buffer);
		return false;
	}
	
	free(buffer);
	return true;
}


