//#include <basetsd.h>
#include <windows.h>
#include <stdio.h>
#include <mapi.h>
#include "SendMessageDll.h"

#pragma comment(lib, "mapi32.lib")

int __stdcall SendSimpleMessage(char* SenderAddress, char* RecverAddress, char* Subject, char* Message)
{
	MapiRecipDesc recver, sender;
	MapiMessage msg;
	ULONG result;
	ULONG session;
	HMODULE hmodule;

	LPMAPISENDMAIL lpfnMAPISendMail;

	LPMAPILOGON  lpfnMAPILogon;
	LPMAPILOGOFF lpfnMAPILogoff;

 
	if ((hmodule=LoadLibrary("mapi32.dll"))==NULL)
	{
		return SEND_MESSAGE_ERROR_LOAD_MAPIDLL;
	}

	if ((lpfnMAPISendMail=(LPMAPISENDMAIL)(GetProcAddress(hmodule, "MAPISendMail")))==NULL)
	{
		FreeLibrary(hmodule);
		return SEND_MESSAGE_ERROR_LOAD_MAPIAPI;
	}

	if ((lpfnMAPILogon = (LPMAPILOGON)(GetProcAddress(hmodule, "MAPILogon")))==NULL)
	{
		FreeLibrary(hmodule);
		return SEND_MESSAGE_ERROR_LOAD_MAPIAPI;
	}

	if ((lpfnMAPILogoff = (LPMAPILOGOFF)(GetProcAddress(hmodule, "MAPILogoff")))==NULL)
	{
		FreeLibrary(hmodule);
		return SEND_MESSAGE_ERROR_LOAD_MAPIAPI;
	}

	result = (*lpfnMAPILogon)(0, NULL, NULL, MAPI_NEW_SESSION, 0, &session);
	if (result != SUCCESS_SUCCESS)
	{
		FreeLibrary(hmodule);
		return SEND_MESSAGE_ERROR_LOGON;
	}

	memset(&sender, 0, sizeof(MapiRecipDesc));
	memset(&recver, 0, sizeof(MapiRecipDesc));
	memset(&msg, 0, sizeof(MapiMessage));

	sender.ulRecipClass = MAPI_ORIG;
	sender.lpszAddress = SenderAddress;
	sender.lpszName = SenderAddress;

	recver.ulRecipClass = MAPI_TO;
	recver.lpszName = RecverAddress;
	recver.lpszAddress = RecverAddress;


	
	msg.lpszNoteText = Message;
	msg.lpszSubject  = Subject;
	msg.lpOriginator = &sender;
	msg.nRecipCount = 1;
	msg.lpRecips = &recver;

	result = lpfnMAPISendMail(session, 0, &msg, 0, 0);
	if (result != SUCCESS_SUCCESS)
	{
		FreeLibrary(hmodule);
		return SEND_MESSAGE_ERROR_SEND;
	}
	result = lpfnMAPILogoff(session, 0, 0, 0);
	if (result != SUCCESS_SUCCESS)
	{
		FreeLibrary(hmodule);
		return SEND_MESSAGE_ERROR_LOGOFF;
	}

	FreeLibrary(hmodule);
	return 0;
	
}


	







