
#define JPEG_SUCCESS                      0
#define JPEG_FAILURE                     -1

#define JPEG_ERROR_IJL_INIT             100
#define JPEG_ERROR_IJL_READ_PARAM       101
#define JPEG_ERROR_IJL_WRITE            102
#define JPEG_ERROR_IJL_READ_DATA        104
#define JPEG_ERROR_IJL_FREE             105
#define JPEG_ERROR_INVALID_FORMAT       106
#define JPEG_ERROR_FILE_CREATE          107
#define JPEG_ERROR_FILE_WRITE           108
#define JPEG_ERROR_INVALID_PARAM        109
#define JPEG_ERROR_READ_BITS            110
#define JPEG_ERROR_CREATE_FILE          111
#define JPEG_ERROR_SET_STRETCH          112

#define JPEG_ERROR_UNSUPPORT_FORMAT     113


#define JPEG_ERROR_MEMORY_ALLOC         120


enum ImageFileFormat
{
	Image_File_Format_BMP, Image_File_Format_JPG, Image_File_Format_PNG,
	Image_File_Format_TIF, Image_File_Format_GIF, Image_File_Format_UNKNOWN
};

const int DefaultThumbnailSize = 64;
const int DefaultMaxHeight     = 500;



int readJpgFile(const char* src, PBITMAPINFO& pbi);
//int createBmpFile(const TCHAR* pszFile, PBITMAPINFO pbi, LPBYTE lpBits);
int createBmpFile(const TCHAR* pszFile, PBITMAPINFO pbi);
//int scaleBmp(PBITMAPINFO pbi,  LPBYTE& lpNewBits, int width, int height);
int readJpgBuffer(const LPBYTE src, DWORD size, PBITMAPINFO& pbi);
int readBmpBuffer(PBITMAPINFO pbi, LPBYTE& dest, DWORD& size, LPBYTE pbits=NULL);

//int createBmpInfoStruct(const BITMAP& bmp, PBITMAPINFO& pbmi);
int scaleBmp(PBITMAPINFO pbi, int width, int height);

bool mapFile(const _TCHAR* fileName, char*& ptr, DWORD& size);
void unmapFile(char* ptr);

int saveJpgFile(const TCHAR* fileName, const LPBYTE dest, DWORD size);
int scaleTo(const LPBYTE jpgPtr, DWORD jpgSize, int thumbWidth, int thumbHeight, 
		int& imageWidth, int& imageHeight, LPBYTE& pbits, DWORD& stretchedSize);

int scaleLessThan(const LPBYTE jpgPtr, DWORD jpgSize, int maxHeight, LPBYTE& pbits,
		int& stretchedWidth, int& stretchedHeight, DWORD& stretchedSize);

int imageProcess(LPBYTE imagePtr, DWORD imageSize, int maxHeight, int thumbSize,
		int& imageWidth, int& imageHeight, int& stretchedWidth, int& stretchedHeight,
		LPBYTE& thumbPtr,
		LPBYTE& stretchedPtr, DWORD& thumbDataSize, DWORD& stretchedSize);
ImageFileFormat imageFileFormat(const LPBYTE image);

void calculateMD5(const unsigned char *data, int nbytes, unsigned char digest[16]);
int scaleBmp(PBITMAPINFO pbi, LPBYTE pbits, LPBYTE& lpNewBits, int width, int height);
void saveToFile(TCHAR* fileName);

bool savePictureFile(LPBYTE buffer, DWORD size);
