#define HTML_PARSE_ERROR     -100
#define HTML_PATH_MAX_ERROR	 -101

#define  MaxDomainNameLength 256

struct DomainNameType
{
	TCHAR nameBuffer[MaxDomainNameLength];
};

struct DomainNameComp
{
	bool operator()(const DomainNameType& first, const DomainNameType& second)const
	{
		return _tcsnicmp((LPCTSTR)first.nameBuffer, (LPCTSTR)second.nameBuffer, 
			MaxDomainNameLength) < 0;
	}
};

typedef std::set<DomainNameType, DomainNameComp> DomainNameSet;
typedef std::deque<DomainNameType> DomainNameQueue;
typedef std::pair<DomainNameSet::iterator, bool> NameResultPair;

int findFirstCharW(LPCTSTR buffer, int size, TCHAR ch);
int findFirstStringW(LPCTSTR buffer, int size, LPCTSTR subStr);

int findNextCharW(LPCTSTR buffer, int size, TCHAR ch);
int findNextStringW(LPCTSTR buffer, int size, LPCTSTR subStr);
int skipSpaceW(LPCTSTR buffer, int size);
bool findFirstWordW(LPCTSTR buffer, int size, int& start, int& end);

////////////////////////////////////////////////////////////////////////

int findFirstCharA(LPCSTR buffer, int size, char ch);
int findFirstStringA(LPCSTR buffer, int size, LPCSTR subStr);

int findNextCharA(LPCSTR buffer, int size, char ch);
int findNextStringA(LPCSTR buffer, int size, LPCSTR subStr);
int skipSpaceA(LPCSTR buffer, int size);
bool findFirstWordA(LPCSTR buffer, int size, int& start, int& end);



struct HtmlParser
{
	DomainNameSet nameSet;	//picture name
	DomainNameSet linkSet;  //hyper link
	DomainNameQueue nameQueue;
	DomainNameQueue linkQueue;
	DomainNameType  currentHost;
	int currentHostNameLength;
	int doParseBufferLinkW(LPCTSTR buffer, int size);
	int doParseBufferImageW(LPCTSTR buffer, int size);
	int doParseBufferLinkA(LPCSTR buffer, int size);
	int doParseBufferImageA(LPCSTR buffer, int size);
	bool parseBuffer(LPTSTR buffer, int size);
	int findFirstImageW(LPCTSTR buffer, int size, DomainNameType& nameBuffer);
	int findFirstLinkW(LPCTSTR buffer, int size, DomainNameType& nameBuffer);
	int findFirstImageA(LPCSTR buffer, int size, DomainNameType& nameBuffer);
	int findFirstLinkA(LPCSTR buffer, int size, DomainNameType& nameBuffer);
	bool retrieveCurrentHost(LPCTSTR www);
	void convertGB2312Buffer(LPTSTR buffer, int size);
	bool isGB2312(LPCTSTR buffer);	
	bool isAnsi(LPCSTR buffer);	
	bool isRelativePath(LPCTSTR www);
	bool isOutsideHostName(LPCTSTR www);

};
